/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.gui;

import com.github.imdmk.spenttime.feature.gui.ParameterizedGui;
import com.github.imdmk.spenttime.feature.gui.SimpleGui;
import com.github.imdmk.spenttime.gui.IdentifiableGui;
import com.github.imdmk.spenttime.task.TaskScheduler;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class GuiManager {
    private final Map<String, IdentifiableGui> identifiableGuis = new ConcurrentHashMap<String, IdentifiableGui>();
    private final TaskScheduler taskScheduler;

    public GuiManager(@NotNull TaskScheduler taskScheduler) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler, "taskScheduler cannot be null");
    }

    public void registerGui(@NotNull IdentifiableGui gui) {
        Objects.requireNonNull(gui, "gui cannot be null");
        Objects.requireNonNull(gui.getIdentifier(), "gui identifier cannot be null");
        this.identifiableGuis.put(gui.getIdentifier(), gui);
    }

    public void openGui(@NotNull String identifier, @NotNull Player player) {
        Objects.requireNonNull(identifier, "identifier cannot be null");
        Objects.requireNonNull(player, "player cannot be null");
        IdentifiableGui gui = this.getGuiOrThrow(identifier);
        if (!(gui instanceof SimpleGui)) {
            throw new IllegalArgumentException("GUI with identifier '" + identifier + "' is not a SimpleGui");
        }
        SimpleGui simpleGui = (SimpleGui)gui;
        this.taskScheduler.runSync(() -> simpleGui.open(player));
    }

    public <T> void openGui(@NotNull String identifier, @NotNull Player viewer, @NotNull T parameter) {
        Objects.requireNonNull(identifier, "identifier cannot be null");
        Objects.requireNonNull(viewer, "viewer cannot be null");
        Objects.requireNonNull(parameter, "parameter cannot be null");
        IdentifiableGui gui = this.getGuiOrThrow(identifier);
        if (!(gui instanceof ParameterizedGui)) {
            throw new IllegalArgumentException("GUI with identifier '" + identifier + "' is not a ParameterizedGui");
        }
        ParameterizedGui paramGui = (ParameterizedGui)gui;
        this.taskScheduler.runSync(() -> paramGui.open(viewer, parameter));
    }

    private IdentifiableGui getGuiOrThrow(@NotNull String identifier) {
        IdentifiableGui gui = this.identifiableGuis.get(identifier);
        if (gui == null) {
            throw new IllegalArgumentException("No GUI registered with identifier '" + identifier + "'");
        }
        return gui;
    }
}

