/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.commands.implementation;

import com.github.imdmk.spenttime.configuration.PluginConfiguration;
import com.github.imdmk.spenttime.feature.gui.GuiManager;
import com.github.imdmk.spenttime.feature.message.MessageService;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.command.Command;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.context.Context;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.execute.Execute;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.permission.Permission;
import com.github.imdmk.spenttime.user.repository.UserRepository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Command(name="spenttime top")
@Permission(value={"command.spenttime.top"})
public class TopCommand {
    private final Logger logger;
    private final PluginConfiguration pluginConfiguration;
    private final UserRepository userRepository;
    private final MessageService messageService;
    private final GuiManager guiManager;

    public TopCommand(@NotNull Logger logger, @NotNull PluginConfiguration pluginConfiguration, @NotNull UserRepository userRepository, @NotNull MessageService messageService, @NotNull GuiManager guiManager) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
        this.pluginConfiguration = Objects.requireNonNull(pluginConfiguration, "pluginConfiguration cannot be null");
        this.userRepository = Objects.requireNonNull(userRepository, "userRepository cannot be null");
        this.messageService = Objects.requireNonNull(messageService, "messageService cannot be null");
        this.guiManager = Objects.requireNonNull(guiManager, "guiManager cannot be null");
    }

    @Execute
    void showTop(@Context Player player) {
        ((CompletableFuture)this.userRepository.findTopUsersBySpentTime(this.pluginConfiguration.querySize).thenAcceptAsync(topUsers -> {
            if (topUsers.isEmpty()) {
                this.messageService.create().viewer(player).notice(notice -> notice.topListEmpty).send();
                return;
            }
            this.guiManager.openGui("spenttimetop", player, topUsers);
        })).exceptionally(throwable -> {
            this.logger.log(Level.SEVERE, "An error occurred while retrieving top list", (Throwable)throwable);
            this.messageService.create().viewer(player).notice(notice -> notice.topListQueryError).send();
            return null;
        });
    }
}

