/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.commands.implementation;

import com.github.imdmk.spenttime.feature.message.MessageService;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.argument.Arg;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.command.Command;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.context.Context;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.execute.Execute;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.permission.Permission;
import com.github.imdmk.spenttime.user.BukkitSpentTime;
import com.github.imdmk.spenttime.user.User;
import com.github.imdmk.spenttime.user.UserService;
import com.github.imdmk.spenttime.util.DurationUtil;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Command(name="spenttime")
public class TimeCommand {
    private final Logger logger;
    private final UserService userService;
    private final MessageService messageService;
    private final BukkitSpentTime bukkitSpentTime;

    public TimeCommand(@NotNull Logger logger, @NotNull UserService userService, @NotNull MessageService messageService, @NotNull BukkitSpentTime bukkitSpentTime) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
        this.userService = Objects.requireNonNull(userService, "userService cannot be null");
        this.messageService = Objects.requireNonNull(messageService, "messageService cannot be null");
        this.bukkitSpentTime = Objects.requireNonNull(bukkitSpentTime, "bukkitSpentTime cannot be null");
    }

    @Execute
    @Permission(value={"command.spenttime"})
    void showTime(@Context Player player) {
        this.updateUser(player).thenRun(() -> this.messageService.create().viewer(player).notice(notice -> notice.ownSpentTime).placeholder("{TIME}", this.getSpentTime(player.getUniqueId())).send());
    }

    @Execute
    @Permission(value={"command.spenttime.target"})
    void showTimeTarget(@Context CommandSender sender, @Arg Player target) {
        this.updateUser(target).thenRun(() -> this.messageService.create().viewer(sender).notice(notice -> notice.otherPlayerSpentTime).placeholder("{PLAYER}", target.getName()).placeholder("{TIME}", this.getSpentTime(target.getUniqueId())).send());
    }

    public CompletableFuture<Void> updateUser(@NotNull Player player) {
        return ((CompletableFuture)this.userService.findOrCreateUser(player).thenCompose(user -> CompletableFuture.runAsync(() -> this.userService.updateUser(player, (User)user)))).exceptionally(throwable -> {
            this.logger.log(Level.SEVERE, "An error occurred while updating user", (Throwable)throwable);
            return null;
        });
    }

    @NotNull
    private String getSpentTime(@NotNull UUID uuid) {
        return DurationUtil.format(this.bukkitSpentTime.getSpentTime(uuid));
    }
}

