/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.commands.implementation;

import com.github.imdmk.spenttime.feature.gui.GuiManager;
import com.github.imdmk.spenttime.feature.gui.implementation.ConfirmationGuiAction;
import com.github.imdmk.spenttime.feature.message.MessageService;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.argument.Arg;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.command.Command;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.context.Context;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.execute.Execute;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.permission.Permission;
import com.github.imdmk.spenttime.user.User;
import com.github.imdmk.spenttime.user.UserService;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Command(name="spenttime reset")
@Permission(value={"command.spenttime.reset"})
public class ResetCommand {
    private final Logger logger;
    private final UserService userService;
    private final MessageService messageService;
    private final GuiManager guiManager;

    public ResetCommand(@NotNull Logger logger, @NotNull UserService userService, @NotNull MessageService messageService, @NotNull GuiManager guiManager) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
        this.userService = Objects.requireNonNull(userService, "userService cannot be null");
        this.messageService = Objects.requireNonNull(messageService, "messageService cannot be null");
        this.guiManager = Objects.requireNonNull(guiManager, "guiManager cannot be null");
    }

    @Execute
    void resetTime(@Context CommandSender sender, @Arg User target) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.openConfirmGui(player, target);
            return;
        }
        this.resetSpentTime(sender, target);
    }

    private void resetSpentTime(@NotNull CommandSender sender, @NotNull User target) {
        this.userService.setSpentTime(target, Duration.ZERO);
        ((CompletableFuture)this.userService.saveUser(target).thenAccept(user -> this.messageService.create().viewer(sender).notice(notice -> notice.playerTimeReset).placeholder("{PLAYER}", target.getName()).send())).exceptionally(throwable -> {
            this.logger.log(Level.SEVERE, "An error occurred while trying to reset target's spent time", (Throwable)throwable);
            this.messageService.send(sender, notice -> notice.playerTimeResetError);
            return null;
        });
    }

    private void openConfirmGui(@NotNull Player viewer, @NotNull User target) {
        this.guiManager.openGui("confirmation", viewer, ConfirmationGuiAction.builder().onConfirm(player -> {
            this.resetSpentTime((CommandSender)player, target);
            player.closeInventory();
        }).onCancel(HumanEntity::closeInventory).build());
    }
}

