/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.commands.implementation;

import com.github.imdmk.spenttime.feature.gui.GuiManager;
import com.github.imdmk.spenttime.feature.gui.implementation.ConfirmationGuiAction;
import com.github.imdmk.spenttime.feature.message.MessageService;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.command.Command;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.context.Context;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.execute.Execute;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.permission.Permission;
import com.github.imdmk.spenttime.user.BukkitSpentTime;
import com.github.imdmk.spenttime.user.repository.UserRepository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Command(name="spenttime reset-all")
@Permission(value={"command.spenttime.reset.all"})
public class ResetAllCommand {
    private final Logger logger;
    private final MessageService messageService;
    private final UserRepository userRepository;
    private final BukkitSpentTime bukkitSpentTime;
    private final GuiManager guiManager;

    public ResetAllCommand(@NotNull Logger logger, @NotNull MessageService messageService, @NotNull UserRepository userRepository, @NotNull BukkitSpentTime bukkitSpentTime, @NotNull GuiManager guiManager) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
        this.messageService = Objects.requireNonNull(messageService, "messageService cannot be null");
        this.userRepository = Objects.requireNonNull(userRepository, "userRepository cannot be null");
        this.bukkitSpentTime = Objects.requireNonNull(bukkitSpentTime, "bukkitSpentTime cannot be null");
        this.guiManager = Objects.requireNonNull(guiManager, "guiManager cannot be null");
    }

    @Execute
    void resetAll(@Context CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.openConfirmGui(player);
            return;
        }
        this.globalResetSpentTime(sender);
    }

    private void globalResetSpentTime(@NotNull CommandSender sender) {
        ((CompletableFuture)this.userRepository.resetGlobalSpentTime().thenAcceptAsync(v -> {
            this.bukkitSpentTime.resetAllSpentTime();
            this.messageService.send(sender, notice -> notice.globalTimeReset);
        })).exceptionally(throwable -> {
            this.logger.log(Level.SEVERE, "An error occurred while trying to reset global spent time", (Throwable)throwable);
            this.messageService.send(sender, notice -> notice.globalTimeResetError);
            return null;
        });
    }

    private void openConfirmGui(@NotNull Player viewer) {
        this.guiManager.openGui("confirmation", viewer, ConfirmationGuiAction.builder().onConfirm(player -> {
            this.globalResetSpentTime((CommandSender)player);
            player.closeInventory();
        }).onCancel(HumanEntity::closeInventory).build());
    }
}

