/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.commands.configuration;

import com.github.imdmk.spenttime.feature.commands.configuration.Command;
import com.github.imdmk.spenttime.feature.commands.configuration.CommandConfiguration;
import com.github.imdmk.spenttime.feature.commands.configuration.SubCommand;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.command.builder.CommandBuilder;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.editor.Editor;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.meta.Meta;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class CommandConfigurator
implements Editor<CommandSender> {
    private final Logger logger;
    private final CommandConfiguration commandConfiguration;

    public CommandConfigurator(@NotNull Logger logger, @NotNull CommandConfiguration commandConfiguration) {
        this.logger = logger;
        this.commandConfiguration = commandConfiguration;
    }

    @Override
    public CommandBuilder<CommandSender> edit(CommandBuilder<CommandSender> context) {
        return this.commandConfiguration.getCommand(context.name()).map(command -> {
            CommandBuilder<CommandSender> updated = this.updateCommand(context, (Command)command);
            return this.updateSubCommand(updated, command.subCommands());
        }).map(command -> {
            this.logger.info("Edited command " + command.name() + " via configuration.");
            return command;
        }).orElse(context);
    }

    @NotNull
    private CommandBuilder<CommandSender> updateCommand(@NotNull CommandBuilder<CommandSender> context, @NotNull Command command) {
        return context.name(command.name()).aliases(command.aliases()).applyMeta(meta -> meta.list(Meta.PERMISSIONS, permissions -> permissions.addAll(command.permissions()))).enabled(command.isEnabled());
    }

    @NotNull
    private CommandBuilder<CommandSender> updateSubCommand(@NotNull CommandBuilder<CommandSender> context, @NotNull Map<String, SubCommand> subCommands) {
        for (Map.Entry<String, SubCommand> entry : subCommands.entrySet()) {
            String id = entry.getKey();
            SubCommand sub = entry.getValue();
            context = context.editChild(id, child -> child.name(sub.name()).aliases(sub.aliases()).applyMeta(meta -> meta.list(Meta.PERMISSIONS, permissions -> permissions.addAll(sub.permissions()))).enabled(sub.isEnabled()));
        }
        return context;
    }
}

