/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.commands.builder.handler;

import com.github.imdmk.spenttime.feature.message.MessageService;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.handler.result.ResultHandlerChain;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invalidusage.InvalidUsageHandler;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.schematic.Schematic;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class UsageHandler
implements InvalidUsageHandler<CommandSender> {
    private final MessageService messageService;

    public UsageHandler(@NotNull MessageService messageService) {
        this.messageService = Objects.requireNonNull(messageService, "message service cannot be null");
    }

    @Override
    public void handle(Invocation<CommandSender> invocation, InvalidUsage<CommandSender> result, ResultHandlerChain<CommandSender> chain) {
        CommandSender sender = invocation.sender();
        Schematic schematic = result.getSchematic();
        if (schematic.isOnlyFirst()) {
            this.messageService.create().viewer(sender).notice(notice -> notice.invalidCommandUsage).placeholder("{USAGE}", schematic.first()).send();
            return;
        }
        this.messageService.create().viewer(sender).notice(notice -> notice.usageHeader).send();
        for (String scheme : schematic.all()) {
            this.messageService.create().viewer(sender).notice(notice -> notice.usageEntry).placeholder("{USAGE}", scheme).send();
        }
    }
}

