/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.configuration.serializer;

import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.serdes.DeserializationData;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.serdes.SerializationData;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ItemStackSerializer
implements ObjectSerializer<ItemStack> {
    @Override
    public boolean supports(@NotNull Class<? super ItemStack> type) {
        return ItemStack.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NotNull ItemStack itemStack, @NotNull SerializationData data, @NotNull GenericsDeclaration generics) {
        Damageable damageable;
        data.add("material", (Object)itemStack.getType(), Material.class);
        if (itemStack.getAmount() > 1) {
            data.add("amount", (Object)itemStack.getAmount(), Integer.class);
        }
        if (itemStack instanceof Damageable && (damageable = (Damageable)itemStack).getDamage() > 0) {
            data.add("durability", (Object)damageable.getDamage(), Short.class);
        }
        if (itemStack.hasItemMeta()) {
            data.add("item-meta", (Object)itemStack.getItemMeta(), ItemMeta.class);
        }
    }

    @Override
    public ItemStack deserialize(@NotNull DeserializationData data, @NotNull GenericsDeclaration generics) {
        Material material = data.get("material", Material.class);
        int amount = Optional.ofNullable(data.get("amount", Integer.class)).orElse(1);
        short durability = Optional.ofNullable(data.get("durability", Short.class)).orElse((short)0);
        ItemStack itemStack = new ItemStack(material, amount);
        Optional.ofNullable(data.get("item-meta", ItemMeta.class)).ifPresent(arg_0 -> ((ItemStack)itemStack).setItemMeta(arg_0));
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            damageable.setDamage((int)durability);
            itemStack.setItemMeta((ItemMeta)damageable);
        }
        return itemStack;
    }
}

