/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.configuration;

import com.github.imdmk.spenttime.configuration.ConfigSection;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.annotation.Comment;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.annotation.Header;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.serdes.commons.SerdesCommons;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

@Header(value={"#", "# A plugin configuration file for the SpentTime plugin.", "#", "# If you have a problem with plugin configuration, please create an issue on the project's github.", "# However, if you like the plugin, leave a star for the project on GitHub.", "# ", "# Support site: https://github.com/imDMK/SpentTime/issues/new/choose", "# GitHub: https://github.com/imDMK/SpentTime", "#"})
public class PluginConfiguration
extends ConfigSection {
    @Comment(value={"# Check for plugin update and send notification after administrator join to server?"})
    public boolean checkUpdate = true;
    @Comment(value={"# How often should the plugin check for updates? Recommended value: 1 day"})
    public Duration updateInterval = Duration.ofDays(1L);
    @Comment(value={"# Specifies how often the player's spent time should be saved in the database", "# Including a spent time top update", "# Recommended value: 10m"})
    public Duration spentTimeSaveDelay = Duration.ofMinutes(10L);
    @Comment(value={"# This determines how many players are to be displayed in the player top", "# WARNING: Increasing this value may increase the consumption of database server resources", "# Recommended value: 10"})
    public int querySize = 10;

    @Override
    @NotNull
    public OkaeriSerdesPack getSerdesPack() {
        return registry -> registry.register(new SerdesCommons());
    }

    @Override
    @NotNull
    public String getFileName() {
        return "pluginConfiguration.yml";
    }
}

