/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.configuration;

import com.github.imdmk.spenttime.configuration.ConfigSection;
import com.github.imdmk.spenttime.configuration.ConfigurationLoadException;
import com.github.imdmk.spenttime.configuration.CustomRepresenter;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.ConfigManager;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.OkaeriConfig;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.exception.OkaeriException;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.yaml.snakeyaml.YamlSnakeYamlConfigurer;
import com.github.imdmk.spenttime.plugin.lib.org.yaml.snakeyaml.DumperOptions;
import com.github.imdmk.spenttime.plugin.lib.org.yaml.snakeyaml.LoaderOptions;
import com.github.imdmk.spenttime.plugin.lib.org.yaml.snakeyaml.Yaml;
import com.github.imdmk.spenttime.plugin.lib.org.yaml.snakeyaml.constructor.Constructor;
import com.github.imdmk.spenttime.plugin.lib.org.yaml.snakeyaml.resolver.Resolver;
import java.io.File;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class ConfigurationManager {
    private final Set<ConfigSection> configs = ConcurrentHashMap.newKeySet();
    private final Logger logger;
    private final ExecutorService executor;

    public ConfigurationManager(@NotNull Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
        this.executor = Executors.newSingleThreadExecutor();
    }

    public <T extends ConfigSection> T create(@NotNull Class<T> config, @NotNull File dataFolder) {
        ConfigSection configFile = (ConfigSection)ConfigManager.create(config);
        File file = new File(dataFolder, configFile.getFileName());
        YamlSnakeYamlConfigurer yamlSnakeYamlConfigurer = this.createYamlSnakeYamlConfigurer();
        configFile.withConfigurer(yamlSnakeYamlConfigurer);
        configFile.withSerdesPack(configFile.getSerdesPack());
        configFile.withBindFile(file);
        configFile.withRemoveOrphans(true);
        configFile.saveDefaults();
        configFile.load(true);
        this.configs.add(configFile);
        return (T)configFile;
    }

    @NotNull
    private YamlSnakeYamlConfigurer createYamlSnakeYamlConfigurer() {
        LoaderOptions loaderOptions = new LoaderOptions();
        Constructor constructor = new Constructor(loaderOptions);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.AUTO);
        dumperOptions.setIndent(2);
        dumperOptions.setSplitLines(false);
        CustomRepresenter representer = new CustomRepresenter(dumperOptions);
        Resolver resolver = new Resolver();
        Yaml yaml = new Yaml(constructor, representer, dumperOptions, loaderOptions, resolver);
        return new YamlSnakeYamlConfigurer(yaml);
    }

    @NotNull
    public CompletableFuture<Void> reloadAll() {
        return CompletableFuture.runAsync(this::loadAll, this.executor);
    }

    private void loadAll() {
        this.configs.forEach(this::load);
    }

    public void load(@NotNull OkaeriConfig config) {
        try {
            config.load(true);
        }
        catch (OkaeriException exception) {
            this.logger.log(Level.SEVERE, "Failed to load config: " + config.getClass().getSimpleName(), exception);
            throw new ConfigurationLoadException(exception);
        }
    }

    public void shutdown() {
        this.logger.info("Shutting down ConfigurationManager executor");
        this.executor.shutdownNow();
    }
}

