/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.shared.message;

import com.github.imdmk.automessage.lib.com.eternalcode.multification.adventure.AudienceConverter;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.bukkit.BukkitMultification;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.provider.NoticeProvider;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.translation.TranslationProvider;
import com.github.imdmk.automessage.lib.net.kyori.adventure.platform.AudienceProvider;
import com.github.imdmk.automessage.lib.net.kyori.adventure.text.Component;
import com.github.imdmk.automessage.lib.net.kyori.adventure.text.minimessage.MiniMessage;
import com.github.imdmk.automessage.lib.net.kyori.adventure.text.serializer.ComponentSerializer;
import com.github.imdmk.automessage.shared.message.MessageConfig;
import com.github.imdmk.automessage.shared.validate.Validator;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class MessageService
extends BukkitMultification<MessageConfig> {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final MessageConfig messageConfig;
    private final AudienceProvider audienceProvider;

    public MessageService(@NotNull MessageConfig messageConfig, @NotNull AudienceProvider audienceProvider) {
        this.messageConfig = Validator.notNull(messageConfig, "messageConfig cannot be null");
        this.audienceProvider = Validator.notNull(audienceProvider, "audienceProvider cannot be null");
    }

    @Override
    @NotNull
    protected TranslationProvider<MessageConfig> translationProvider() {
        return provider -> this.messageConfig;
    }

    @Override
    @NotNull
    protected ComponentSerializer<Component, Component, String> serializer() {
        return MINI_MESSAGE;
    }

    @Override
    @NotNull
    protected AudienceConverter<CommandSender> audienceConverter() {
        return sender -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                return this.audienceProvider.player(player.getUniqueId());
            }
            return this.audienceProvider.console();
        };
    }

    public void send(@NotNull CommandSender sender, @NotNull NoticeProvider<MessageConfig> notice) {
        Validator.notNull(sender, "sender cannot be null");
        Validator.notNull(notice, "notice cannot be null");
        this.create().viewer(sender).notice(notice).send();
    }
}

