/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.scheduled.selector;

import com.github.imdmk.automessage.scheduled.ScheduledMessage;
import com.github.imdmk.automessage.scheduled.selector.MessageSelector;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

final class SequentialMessageSelector
implements MessageSelector {
    private static final int RESET_THRESHOLD = 1000000000;
    private final AtomicInteger index = new AtomicInteger(0);

    SequentialMessageSelector() {
    }

    @Override
    public Optional<ScheduledMessage> selectNext(@NotNull List<ScheduledMessage> messages, boolean advanceIndex) {
        int size = messages.size();
        if (size == 0) {
            return Optional.empty();
        }
        int current = this.index.get();
        int position = Math.floorMod(current, size);
        ScheduledMessage selected = messages.get(position);
        if (advanceIndex) {
            int next = current + 1;
            if (next >= 1000000000) {
                next = 0;
            }
            this.index.set(next);
        }
        return Optional.of(selected);
    }
}

