/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.scheduled.dispatcher;

import com.github.imdmk.automessage.platform.scheduler.PluginTask;
import com.github.imdmk.automessage.scheduled.dispatcher.DispatchTarget;
import com.github.imdmk.automessage.scheduled.dispatcher.MessageDispatcher;
import com.github.imdmk.automessage.scheduled.dispatcher.MessageDispatcherConfig;
import com.github.imdmk.automessage.shared.validate.Validator;
import java.time.Duration;
import java.util.Collection;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;

public final class MessageDispatcherTask
implements PluginTask {
    private final Server server;
    private final MessageDispatcherConfig dispatcherConfig;
    private final MessageDispatcher messageDispatcher;

    public MessageDispatcherTask(@NotNull Server server, @NotNull MessageDispatcherConfig dispatcherConfig, @NotNull MessageDispatcher messageDispatcher) {
        this.server = Validator.notNull(server, "server");
        this.dispatcherConfig = Validator.notNull(dispatcherConfig, "dispatcherConfig");
        this.messageDispatcher = Validator.notNull(messageDispatcher, "messageDispatcher");
    }

    @Override
    public void run() {
        if (!this.dispatcherConfig.enabled) {
            return;
        }
        Collection onlinePlayers = this.server.getOnlinePlayers();
        if (onlinePlayers.isEmpty()) {
            return;
        }
        DispatchTarget target = DispatchTarget.players(onlinePlayers);
        this.messageDispatcher.dispatchNext(target);
    }

    @Override
    public Duration delay() {
        return this.dispatcherConfig.initialDelay;
    }

    @Override
    public Duration period() {
        return this.dispatcherConfig.period;
    }
}

