/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.scheduled.dispatcher;

import com.github.imdmk.automessage.config.ConfigSection;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.annotation.Comment;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.annotation.Header;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import com.github.imdmk.automessage.scheduled.selector.MessageSelectorType;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

@Header(value={"# ============================================================================", "#                        AutoMessage \u2014 messagesDispatcher.yml", "# ============================================================================", "# This file controls how AutoMessage dispatches scheduled announcements.", "# It defines startup timing, repeat intervals, and which message-selection", "# strategy the dispatcher should use.", "#", "# Fields:", "#  enabled:", "#    Master switch controlling whether automatic message dispatching is active.", "#    true  -> messages cycle automatically", "#    false -> announcements are paused", "#", "#  period:", "#    Time between consecutive dispatch executions.", "#    Examples: 10s, 1m, 500ms", "#", "#  initialDelay:", "#    How long the dispatcher should wait before sending the first message", "#    after plugin startup.", "#", "#  selector:", "#    Strategy determining which scheduled message is selected next.", "#    Supported types:", "#       SEQUENTIAL \u2013 cycle through messages in order", "#       RANDOM     \u2013 choose a random message each time", "#", "# Notes:", "#  \u2022 This file works together with scheduledMessages.yml.", "#  \u2022 After editing this file you must restart the server, as dispatcher", "#    scheduling is configured during plugin initialization.", "#", "# Source Code:", "#   https://github.com/imDMK/AutoMessage", "#", "# Support development:", "#   GitHub Sponsors: https://github.com/sponsors/imDMK", "#   PayPal:          https://paypal.me/dominiksuliga", "#", "# ============================================================================"})
public final class MessageDispatcherConfig
extends ConfigSection {
    @Comment(value={"#", "# Whether automatic scheduled-message dispatching is enabled.", "#"})
    public boolean enabled = true;
    @Comment(value={"#", "# Delay between automatic dispatch executions.", "#"})
    public Duration period = Duration.ofSeconds(10L);
    @Comment(value={"#", "# Initial delay before the very first automatic message dispatch.", "#"})
    public Duration initialDelay = Duration.ofSeconds(10L);
    @Comment(value={"#", "# Strategy used to select which scheduled message will be dispatched next.", "# Available options: SEQUENTIAL, RANDOM", "#"})
    public MessageSelectorType selector = MessageSelectorType.SEQUENTIAL;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @NotNull
    public OkaeriSerdesPack getSerdesPack() {
        return registry -> {};
    }

    @Override
    @NotNull
    public String getFileName() {
        return "messagesDispatcher.yml";
    }
}

