/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.scheduled.dispatcher;

import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.Notice;
import com.github.imdmk.automessage.scheduled.ScheduledMessage;
import com.github.imdmk.automessage.scheduled.audience.filter.AudienceFilter;
import com.github.imdmk.automessage.scheduled.dispatcher.DispatchTarget;
import com.github.imdmk.automessage.scheduled.selector.MessageSelector;
import com.github.imdmk.automessage.shared.message.MessageService;
import com.github.imdmk.automessage.shared.validate.Validator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class MessageDispatcher {
    private final MessageService messageService;
    private final MessageSelector selector;
    private final AudienceFilter filter;
    private final Supplier<List<ScheduledMessage>> messagesSupplier;

    public MessageDispatcher(@NotNull MessageService messageService, @NotNull MessageSelector selector, @NotNull AudienceFilter filter, @NotNull Supplier<List<ScheduledMessage>> messagesSupplier) {
        this.messageService = Validator.notNull(messageService, "messageService");
        this.selector = Validator.notNull(selector, "selector");
        this.filter = Validator.notNull(filter, "filter");
        this.messagesSupplier = Validator.notNull(messagesSupplier, "messagesSupplier");
    }

    public void dispatchNext(@NotNull DispatchTarget target) {
        this.dispatchNext(target, true);
    }

    public void dispatchNext(@NotNull DispatchTarget target, boolean advanceSelectorIndex) {
        List<ScheduledMessage> messages = this.messagesSupplier.get();
        if (messages.isEmpty()) {
            return;
        }
        Optional<ScheduledMessage> next = this.selector.selectNext(messages, advanceSelectorIndex);
        next.ifPresent(message -> this.dispatch((ScheduledMessage)message, target));
    }

    public void dispatch(@NotNull ScheduledMessage message, @NotNull DispatchTarget target) {
        for (Player player : target.recipients()) {
            if (!this.filter.allows(player, message)) continue;
            this.sendToPlayer(player, message);
        }
    }

    private void sendToPlayer(@NotNull Player player, @NotNull ScheduledMessage message) {
        for (Notice notice : message.notices()) {
            this.messageService.create().viewer(player).notice(notice).sendAsync();
        }
    }
}

