/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.scheduled.dispatcher;

import com.github.imdmk.automessage.scheduled.dispatcher.DispatchFilteredTarget;
import com.github.imdmk.automessage.scheduled.dispatcher.DispatchPlayersTarget;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public interface DispatchTarget {
    @NotNull
    public Collection<? extends Player> recipients();

    @NotNull
    public static DispatchTarget player(@NotNull Player player) {
        return new DispatchPlayersTarget(List.of(player));
    }

    @NotNull
    public static DispatchTarget players(@NotNull Collection<? extends Player> players) {
        return new DispatchPlayersTarget(players);
    }

    @NotNull
    public static DispatchTarget filtered(@NotNull Collection<? extends Player> players, @NotNull Predicate<Player> filter) {
        return new DispatchFilteredTarget(players, filter);
    }
}

