/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.scheduled;

import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.Notice;
import com.github.imdmk.automessage.scheduled.ScheduledMessage;
import com.github.imdmk.automessage.scheduled.audience.rule.AudienceRule;
import com.github.imdmk.automessage.shared.validate.Validator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ScheduledMessageBuilder {
    private String name;
    private final List<Notice> notices = new ArrayList<Notice>();
    private final List<AudienceRule> rules = new ArrayList<AudienceRule>();

    public static ScheduledMessageBuilder create() {
        return new ScheduledMessageBuilder();
    }

    @NotNull
    public ScheduledMessageBuilder name(@NotNull String name) {
        this.name = Validator.notNull(name, "name");
        return this;
    }

    @NotNull
    public ScheduledMessageBuilder addNotice(@NotNull Notice notice) {
        this.notices.add(Validator.notNull(notice, "notice"));
        return this;
    }

    @NotNull
    public ScheduledMessageBuilder addNotices(@NotNull List<Notice> notices) {
        Validator.notNull(notices, "notices");
        notices.forEach(n -> this.notices.add(Validator.notNull(n, "notice element")));
        return this;
    }

    @NotNull
    public ScheduledMessageBuilder addNotices(Notice ... notices) {
        return this.addNotices(List.of(notices));
    }

    @NotNull
    public ScheduledMessageBuilder addRule(@NotNull AudienceRule rule) {
        this.rules.add(Validator.notNull(rule, "rule"));
        return this;
    }

    @NotNull
    public ScheduledMessageBuilder addRules(@NotNull List<AudienceRule> rules) {
        Validator.notNull(rules, "rules");
        rules.forEach(r -> this.rules.add(Validator.notNull(r, "rule element")));
        return this;
    }

    @NotNull
    public ScheduledMessageBuilder addRules(AudienceRule ... rules) {
        return this.addRules(List.of(rules));
    }

    @NotNull
    public ScheduledMessage build() {
        Validator.notNull(this.name, "name is required");
        return new ScheduledMessage(this.name, List.copyOf(this.notices), List.copyOf(this.rules));
    }
}

