/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.platform.scheduler;

import com.github.imdmk.automessage.platform.scheduler.PluginTask;
import com.github.imdmk.automessage.platform.scheduler.TaskScheduler;
import com.github.imdmk.automessage.shared.validate.Validator;
import java.time.Duration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public final class BukkitTaskScheduler
implements TaskScheduler {
    private static final long MILLIS_PER_TICK = 50L;
    private final Plugin plugin;
    private final BukkitScheduler scheduler;

    public BukkitTaskScheduler(@NotNull Plugin plugin, @NotNull BukkitScheduler scheduler) {
        this.plugin = Validator.notNull(plugin, "plugin");
        this.scheduler = Validator.notNull(scheduler, "scheduler");
    }

    @Override
    @NotNull
    public BukkitTask runSync(@NotNull Runnable runnable) {
        Validator.notNull(runnable, "runnable cannot be null");
        return this.scheduler.runTask(this.plugin, runnable);
    }

    @Override
    @NotNull
    public BukkitTask runSync(@NotNull PluginTask task) {
        Validator.notNull(task, "task cannot be null");
        return this.scheduler.runTask(this.plugin, (Runnable)task);
    }

    @Override
    @NotNull
    public BukkitTask runAsync(@NotNull Runnable runnable) {
        Validator.notNull(runnable, "runnable cannot be null");
        return this.scheduler.runTaskAsynchronously(this.plugin, runnable);
    }

    @Override
    @NotNull
    public BukkitTask runAsync(@NotNull PluginTask task) {
        Validator.notNull(task, "task cannot be null");
        return this.scheduler.runTaskAsynchronously(this.plugin, (Runnable)task);
    }

    @Override
    @NotNull
    public BukkitTask runLaterAsync(@NotNull Runnable runnable, @NotNull Duration delay) {
        Validator.notNull(runnable, "runnable cannot be null");
        Validator.notNull(delay, "delay cannot be null");
        return this.scheduler.runTaskLaterAsynchronously(this.plugin, runnable, (long)BukkitTaskScheduler.toTicks(delay));
    }

    @Override
    @NotNull
    public BukkitTask runLaterAsync(@NotNull PluginTask task) {
        Validator.notNull(task, "task cannot be null");
        return this.runLaterAsync(task, task.delay());
    }

    @Override
    @NotNull
    public BukkitTask runLaterSync(@NotNull Runnable runnable, @NotNull Duration delay) {
        Validator.notNull(runnable, "runnable cannot be null");
        Validator.notNull(delay, "delay cannot be null");
        return this.scheduler.runTaskLater(this.plugin, runnable, (long)BukkitTaskScheduler.toTicks(delay));
    }

    @Override
    @NotNull
    public BukkitTask runLaterSync(@NotNull PluginTask task) {
        Validator.notNull(task, "task cannot be null");
        return this.runLaterSync(task, task.delay());
    }

    @Override
    @NotNull
    public BukkitTask runTimerSync(@NotNull Runnable runnable, @NotNull Duration delay, @NotNull Duration period) {
        Validator.notNull(runnable, "runnable cannot be null");
        Validator.notNull(delay, "delay cannot be null");
        Validator.notNull(period, "period cannot be null");
        return this.scheduler.runTaskTimer(this.plugin, runnable, (long)BukkitTaskScheduler.toTicks(delay), (long)BukkitTaskScheduler.toTicks(period));
    }

    @Override
    @NotNull
    public BukkitTask runTimerSync(@NotNull PluginTask task) {
        Validator.notNull(task, "task cannot be null");
        return this.runTimerSync(task, task.delay(), task.period());
    }

    @Override
    @NotNull
    public BukkitTask runTimerAsync(@NotNull Runnable runnable, @NotNull Duration delay, @NotNull Duration period) {
        Validator.notNull(runnable, "runnable cannot be null");
        Validator.notNull(delay, "delay cannot be null");
        Validator.notNull(period, "period cannot be null");
        return this.scheduler.runTaskTimerAsynchronously(this.plugin, runnable, (long)BukkitTaskScheduler.toTicks(delay), (long)BukkitTaskScheduler.toTicks(period));
    }

    @Override
    @NotNull
    public BukkitTask runTimerAsync(@NotNull PluginTask task) {
        Validator.notNull(task, "task cannot be null");
        return this.runTimerAsync(task, task.delay(), task.period());
    }

    @Override
    public void cancelTask(int taskId) {
        this.scheduler.cancelTask(taskId);
    }

    @Override
    public void shutdown() {
        this.scheduler.cancelTasks(this.plugin);
    }

    private static int toTicks(@NotNull Duration duration) {
        Validator.notNull(duration, "duration cannot be null");
        long ticks = duration.toMillis() / 50L;
        return ticks <= 0L ? 0 : (int)ticks;
    }
}

