/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.platform.logger;

import com.github.imdmk.automessage.platform.logger.PluginLogger;
import com.github.imdmk.automessage.shared.validate.Validator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class BukkitPluginLogger
implements PluginLogger {
    private final Logger logger;

    public BukkitPluginLogger(@NotNull Logger logger) {
        this.logger = Validator.notNull(logger, "logger");
    }

    public BukkitPluginLogger(@NotNull Plugin plugin) {
        this(plugin.getLogger());
    }

    @Override
    public void info(@NotNull String message) {
        this.logger.info(message);
    }

    @Override
    public void info(@NotNull String message, Object ... args) {
        this.logger.log(Level.INFO, this.format(message, args));
    }

    @Override
    public void warn(@NotNull String message) {
        this.logger.warning(message);
    }

    @Override
    public void warn(@NotNull Throwable throwable) {
        this.logger.log(Level.WARNING, "A warning occurred, see stack trace for details.", throwable);
    }

    @Override
    public void warn(@NotNull Throwable throwable, @NotNull String message, Object ... args) {
        this.logger.log(Level.WARNING, this.format(message, args), throwable);
    }

    @Override
    public void warn(@NotNull String message, Object ... args) {
        this.logger.log(Level.WARNING, this.format(message, args));
    }

    @Override
    public void error(@NotNull Throwable throwable) {
        this.logger.log(Level.SEVERE, "An error occurred, see stack trace for details.", throwable);
    }

    @Override
    public void error(@NotNull String message) {
        this.logger.log(Level.SEVERE, message);
    }

    @Override
    public void error(@NotNull String message, Object ... args) {
        this.logger.log(Level.SEVERE, this.format(message, args));
    }

    @Override
    public void error(@NotNull Throwable throwable, @NotNull String message) {
        this.logger.log(Level.SEVERE, message, throwable);
    }

    @Override
    public void error(@NotNull Throwable throwable, @NotNull String message, Object ... args) {
        this.logger.log(Level.SEVERE, this.format(message, args), throwable);
    }

    private String format(String message, Object ... args) {
        return String.format(Locale.ROOT, message, args);
    }
}

