/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.platform.litecommands.handler;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.handler.result.ResultHandlerChain;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invalidusage.InvalidUsageHandler;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.schematic.Schematic;
import com.github.imdmk.automessage.shared.message.MessageService;
import com.github.imdmk.automessage.shared.validate.Validator;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public final class InvalidUsageHandlerImpl
implements InvalidUsageHandler<CommandSender> {
    private final MessageService messageService;

    public InvalidUsageHandlerImpl(@NotNull MessageService messageService) {
        this.messageService = Validator.notNull(messageService, "messageService cannot be null");
    }

    @Override
    public void handle(Invocation<CommandSender> invocation, InvalidUsage<CommandSender> result, ResultHandlerChain<CommandSender> chain) {
        CommandSender sender = invocation.sender();
        Schematic schematic = result.getSchematic();
        if (schematic.isOnlyFirst()) {
            this.messageService.create().viewer(sender).notice(notice -> notice.liteCommandsMessages.commandUsageInvalid()).placeholder("{USAGE}", schematic.first()).send();
            return;
        }
        this.messageService.create().viewer(sender).notice(notice -> notice.liteCommandsMessages.commandUsageHeader()).send();
        for (String sch : schematic.all()) {
            this.messageService.create().viewer(sender).notice(notice -> notice.liteCommandsMessages.commandUsageEntry()).placeholder("{USAGE}", sch).send();
        }
    }
}

