/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.eu.okaeri.configs.yaml.snakeyaml;

import com.github.imdmk.automessage.lib.eu.okaeri.configs.configurer.Configurer;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.postprocessor.ConfigLineInfo;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.postprocessor.ConfigPostprocessor;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.postprocessor.format.YamlSectionWalker;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.schema.ConfigDeclaration;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.schema.FieldDeclaration;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.serdes.SerdesContext;
import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.DumperOptions;
import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.LoaderOptions;
import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.Yaml;
import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.constructor.Constructor;
import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.representer.Representer;
import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.resolver.Resolver;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;

public class YamlSnakeYamlConfigurer
extends Configurer {
    private Yaml yaml;
    private Map<String, Object> map = new LinkedHashMap<String, Object>();
    private String commentPrefix = "# ";

    public YamlSnakeYamlConfigurer(@NonNull Yaml yaml, @NonNull Map<String, Object> map) {
        if (yaml == null) {
            throw new NullPointerException("yaml is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        this.yaml = yaml;
        this.map = map;
    }

    public YamlSnakeYamlConfigurer(@NonNull Yaml yaml) {
        if (yaml == null) {
            throw new NullPointerException("yaml is marked non-null but is null");
        }
        this.yaml = yaml;
    }

    public YamlSnakeYamlConfigurer() {
        this(YamlSnakeYamlConfigurer.createYaml());
    }

    private static Yaml createYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        Constructor constructor = new Constructor(loaderOptions);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Representer representer = new Representer(dumperOptions);
        representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Resolver resolver = new Resolver();
        return new Yaml(constructor, representer, dumperOptions, loaderOptions, resolver);
    }

    private static <T> T apply(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    @Override
    public List<String> getExtensions() {
        return Arrays.asList("yml", "yaml");
    }

    @Override
    public void setValue(@NonNull String key, Object value, GenericsDeclaration type, FieldDeclaration field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Object simplified = this.simplify(value, type, SerdesContext.of(this, field), true);
        this.map.put(key, simplified);
    }

    @Override
    public void setValueUnsafe(@NonNull String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.map.put(key, value);
    }

    @Override
    public Object getValue(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.map.get(key);
    }

    @Override
    public Object remove(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.map.remove(key);
    }

    @Override
    public boolean keyExists(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.map.containsKey(key);
    }

    @Override
    public List<String> getAllKeys() {
        return Collections.unmodifiableList(new ArrayList<String>(this.map.keySet()));
    }

    @Override
    public void load(@NonNull InputStream inputStream, @NonNull ConfigDeclaration declaration) throws Exception {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (declaration == null) {
            throw new NullPointerException("declaration is marked non-null but is null");
        }
        this.map = (Map)this.yaml.load(inputStream);
        if (this.map == null) {
            this.map = new LinkedHashMap<String, Object>();
        }
    }

    @Override
    public void write(@NonNull OutputStream outputStream, final @NonNull ConfigDeclaration declaration) throws Exception {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (declaration == null) {
            throw new NullPointerException("declaration is marked non-null but is null");
        }
        String contents = this.yaml.dump(this.map);
        ConfigPostprocessor.of(contents).removeLines(line -> line.startsWith(this.commentPrefix.trim())).updateLinesKeys(new YamlSectionWalker(){

            @Override
            public String update(String line, ConfigLineInfo lineInfo, List<ConfigLineInfo> path) {
                ConfigDeclaration currentDeclaration = declaration;
                for (int i = 0; i < path.size() - 1; ++i) {
                    ConfigLineInfo pathElement = path.get(i);
                    Optional<FieldDeclaration> field = currentDeclaration.getField(pathElement.getName());
                    if (!field.isPresent()) {
                        return line;
                    }
                    GenericsDeclaration fieldType = field.get().getType();
                    if (!fieldType.isConfig()) {
                        return line;
                    }
                    currentDeclaration = ConfigDeclaration.of(fieldType.getType());
                }
                Optional<FieldDeclaration> lineDeclaration = currentDeclaration.getField(lineInfo.getName());
                if (!lineDeclaration.isPresent()) {
                    return line;
                }
                String[] fieldComment = lineDeclaration.get().getComment();
                if (fieldComment == null) {
                    return line;
                }
                String comment = ConfigPostprocessor.createComment(YamlSnakeYamlConfigurer.this.commentPrefix, fieldComment);
                return ConfigPostprocessor.addIndent(comment, lineInfo.getIndent()) + line;
            }
        }).prependContextComment(this.commentPrefix, declaration.getHeader()).write(outputStream);
    }

    @Generated
    public YamlSnakeYamlConfigurer setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
        return this;
    }
}

