/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.util;

import java.util.Arrays;
import java.util.Collection;

public final class LiteCommandsUtil {
    private LiteCommandsUtil() {
    }

    public static boolean checkConsistent(String name, String[] aliases) {
        if (!LiteCommandsUtil.checkName(name)) {
            return false;
        }
        int countName = name.split(" ").length;
        for (String alias : aliases) {
            if (alias == null) {
                throw new NullPointerException("Alias cannot be null");
            }
            if (alias.split(" ").length == countName) continue;
            throw new IllegalArgumentException("Alias '" + alias + "' has different count of words than name '" + name + "'");
        }
        return LiteCommandsUtil.checkAliases(aliases);
    }

    public static boolean checkName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.isEmpty()) {
            return false;
        }
        if (name.contains("  ")) {
            throw new IllegalArgumentException("Name cannot contain two spaces in a row");
        }
        if (name.startsWith(" ") || name.endsWith(" ")) {
            throw new IllegalArgumentException("Name cannot start or end with space");
        }
        return true;
    }

    public static boolean checkAliases(String[] aliases) {
        return LiteCommandsUtil.checkAliases(Arrays.asList(aliases));
    }

    public static boolean checkAliases(Collection<String> aliases) {
        if (aliases == null) {
            throw new NullPointerException("Aliases cannot be null");
        }
        for (String alias : aliases) {
            if (LiteCommandsUtil.checkName(alias)) continue;
            throw new IllegalStateException("Alias '" + alias + "' is not consistent");
        }
        return true;
    }
}

