/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SchedulerType {
    public static final SchedulerType MAIN = new SchedulerType("main", new SchedulerType[0]);
    public static final SchedulerType ASYNCHRONOUS = new SchedulerType("async", MAIN);
    public static final SchedulerType COMPLETABLE_FUTURE = new SchedulerType("completable_future", ASYNCHRONOUS);
    public static final SchedulerType EXECUTOR = new SchedulerType("executor", MAIN);
    public static final SchedulerType SUGGESTER = new SchedulerType("suggester", ASYNCHRONOUS);
    private final String name;
    private final Set<SchedulerType> replaceable = new HashSet<SchedulerType>();
    private final boolean logging;

    protected SchedulerType(String name, SchedulerType ... replaceable) {
        this(name, false, replaceable);
    }

    protected SchedulerType(String name, boolean logging, SchedulerType ... replaceable) {
        this.name = name;
        this.replaceable.addAll(Arrays.asList(replaceable));
        this.logging = logging;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public SchedulerType logging() {
        return new SchedulerType(this.name, true, this.replaceable.toArray(new SchedulerType[0]));
    }

    public Optional<SchedulerType> resolve(SchedulerType ... available) {
        return this.resolve(Arrays.asList(available));
    }

    public Optional<SchedulerType> resolve(Collection<SchedulerType> available) {
        if (available.isEmpty()) {
            throw new IllegalStateException("Cannot resolve the thread type");
        }
        if (available.contains(this)) {
            return Optional.of(this);
        }
        for (SchedulerType poll : this.replaceable) {
            if (!available.contains(poll)) continue;
            return Optional.of(poll);
        }
        for (SchedulerType poll : this.replaceable) {
            Optional<SchedulerType> resolve = poll.resolve(available);
            if (!resolve.isPresent()) continue;
            return resolve;
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulerType that = (SchedulerType)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "SchedulerType{name='" + this.name + '\'' + ", logging=" + this.logging + '}';
    }
}

