/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler.Scheduler;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler.SchedulerType;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.ThrowingSupplier;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractMainThreadBasedScheduler
implements Scheduler {
    @Override
    public final <T> CompletableFuture<T> supplyLater(SchedulerType type, Duration delay, ThrowingSupplier<T, Throwable> supplier) {
        SchedulerType resolved = type.resolve(SchedulerType.MAIN, SchedulerType.ASYNCHRONOUS).orElse(type);
        CompletableFuture future = new CompletableFuture();
        Runnable task = () -> this.tryRun(type, future, supplier);
        if (resolved.equals(SchedulerType.MAIN)) {
            this.runSynchronous(task, delay);
            return future;
        }
        if (resolved.equals(SchedulerType.ASYNCHRONOUS)) {
            this.runAsynchronous(task, delay);
            return future;
        }
        boolean isResolved = this.runUnknown(type, delay, task);
        if (isResolved) {
            return future;
        }
        throw new IllegalArgumentException("Unknown scheduler poll type: " + type);
    }

    protected boolean runUnknown(SchedulerType type, Duration delay, Runnable task) {
        return false;
    }

    protected abstract void runSynchronous(Runnable var1, Duration var2);

    protected abstract void runAsynchronous(Runnable var1, Duration var2);

    private <T> void tryRun(SchedulerType type, CompletableFuture<T> future, ThrowingSupplier<T, Throwable> supplier) {
        block2: {
            try {
                future.complete(supplier.get());
            }
            catch (Throwable throwable) {
                future.completeExceptionally(throwable);
                if (!type.isLogging()) break block2;
                this.log(throwable);
            }
        }
    }

    protected void log(Throwable throwable) {
    }
}

