/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParserRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.input.ParseableInputMatcher;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bind.BindRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecutor;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecutorMatchResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.context.ContextRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.Meta;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.Requirement;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.RequirementCondition;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.RequirementMatch;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.RequirementsResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.ScheduledRequirement;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.ScheduledRequirementResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler.Scheduler;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.FailedReason;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.strict.StrictService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.validator.ValidatorResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.validator.requirement.RequirementValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class RequirementMatchService<SENDER> {
    private final ScheduledRequirementResolver<SENDER> scheduledRequirementResolver;
    private final StrictService strictService;

    public RequirementMatchService(StrictService strictService, ContextRegistry<SENDER> contextRegistry, ParserRegistry<SENDER> parserRegistry, BindRegistry bindRegistry, Scheduler scheduler) {
        this.strictService = strictService;
        this.scheduledRequirementResolver = new ScheduledRequirementResolver<SENDER>(contextRegistry, parserRegistry, bindRegistry, scheduler);
    }

    public <MATCHER extends ParseableInputMatcher<MATCHER>> CompletableFuture<CommandExecutorMatchResult> match(CommandExecutor<SENDER> executor, Invocation<SENDER> invocation, MATCHER matcher) {
        List<ScheduledRequirement<?>> scheduledRequirements = this.scheduledRequirementResolver.prepareRequirements(executor, invocation, matcher);
        return this.match(invocation, executor, new ArrayList<RequirementMatch>(), scheduledRequirements.listIterator(), matcher);
    }

    private CompletableFuture<CommandExecutorMatchResult> match(Invocation<SENDER> invocation, CommandExecutor<SENDER> executor, List<RequirementMatch> matches, Iterator<ScheduledRequirement<?>> requirementIterator, ParseableInputMatcher<?> matcher) {
        if (!requirementIterator.hasNext()) {
            ParseableInputMatcher.EndResult endResult = matcher.endMatch(this.strictService.isStrict(executor));
            if (!endResult.isSuccessful()) {
                return CompletableFuture.completedFuture(CommandExecutorMatchResult.failed(endResult.getFailedReason()));
            }
            RequirementsResult.Builder<SENDER> resultBuilder = RequirementsResult.builder(invocation);
            for (RequirementMatch success : matches) {
                resultBuilder.add(success.getRequirement().getName(), success);
            }
            return CompletableFuture.completedFuture(executor.match(resultBuilder.build()));
        }
        ScheduledRequirement<?> scheduledRequirement = requirementIterator.next();
        return ((CompletableFuture)scheduledRequirement.runMatch().thenCompose(result -> result.asFuture())).thenCompose(requirementResult -> {
            Requirement requirement = scheduledRequirement.getRequirement();
            if (requirementResult.isFailed()) {
                return CompletableFuture.completedFuture(CommandExecutorMatchResult.failed(requirementResult.getFailedReason()));
            }
            if (requirementResult.isSuccessfulNull()) {
                matches.add(this.toMatch(requirement, null));
                return this.match(invocation, executor, matches, requirementIterator, matcher);
            }
            Object success = requirementResult.getSuccess();
            List<RequirementValidator<?, ?>> validators = requirement.meta().get(Meta.REQUIREMENT_VALIDATORS);
            for (RequirementValidator<?, ?> validator : validators) {
                ValidatorResult validatorResult = this.validateRequirement(invocation, executor, requirement, success, validator);
                if (!validatorResult.isInvalid()) continue;
                return CompletableFuture.completedFuture(CommandExecutorMatchResult.failed(validatorResult.getInvalidResult()));
            }
            matches.add(this.toMatch(requirement, success));
            return this.match(invocation, executor, matches, requirementIterator, matcher).thenApply(executorMatchResult -> {
                for (RequirementCondition condition : requirementResult.getConditions()) {
                    Optional<FailedReason> failedReason = condition.check(invocation, (CommandExecutorMatchResult)executorMatchResult);
                    if (!failedReason.isPresent()) continue;
                    return CommandExecutorMatchResult.failed(failedReason.get());
                }
                return executorMatchResult;
            });
        });
    }

    @Deprecated
    private <T> ValidatorResult validateRequirement(Invocation<SENDER> invocation, CommandExecutor<SENDER> executor, Requirement<?> requirement, T value, RequirementValidator<?, ?> validator) {
        Requirement<?> castedRequirement = requirement;
        RequirementValidator<?, ?> casted = validator;
        return casted.validate(invocation, executor, castedRequirement, value);
    }

    private <R extends Requirement<? extends T>, T> RequirementMatch toMatch(R requirement, T result) {
        return new RequirementMatch(requirement, result);
    }
}

