/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.type;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.type.TypeTokenBuilder;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.type.TypeUtil;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.Preconditions;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public abstract class TypeToken<T> {
    private final Class<T> rawType;
    private final Type type;

    protected TypeToken() {
        this.type = this.capture();
        this.rawType = TypeUtil.getRawType(this.type);
    }

    TypeToken(Type type) {
        this.type = type;
        this.rawType = TypeUtil.getRawType(type);
    }

    private Type capture() {
        Type superclass = this.getClass().getGenericSuperclass();
        Preconditions.checkArgument(superclass instanceof ParameterizedType, "%s isn't parameterized", superclass);
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    public Type getType() {
        return this.type;
    }

    public Class<T> getRawType() {
        return this.rawType;
    }

    public final boolean isPrimitive() {
        return this.type instanceof Class && ((Class)this.type).isPrimitive();
    }

    public boolean isInstanceOf(TypeToken<?> typeToken) {
        return this.isInstanceOf(typeToken.getRawType());
    }

    public boolean isInstanceOf(Class<?> type) {
        return type == Object.class || type.isAssignableFrom(this.getRawType());
    }

    public TypeToken<?> getParameterized() {
        return this.getParameterized(0);
    }

    public TypeToken<?> getParameterized(int index) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (this.type instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)this.type).getActualTypeArguments()).length > index) {
            return TypeToken.of(actualTypeArguments[index]);
        }
        throw new IllegalStateException("Cannot resolve parameterized type");
    }

    public boolean isArray() {
        return this.getRawType().isArray();
    }

    public Class<?> getComponentType() {
        return this.getRawType().getComponentType();
    }

    public TypeToken<?> getComponentTypeToken() {
        return TypeToken.of(this.getComponentType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeToken typeToken = (TypeToken)o;
        return Objects.equals(this.type, typeToken.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public static <T> TypeToken<T> of(Class<T> type) {
        return new SimpleTypeToken<T>(type);
    }

    public static <T> TypeToken<T> of(Type type) {
        return new SimpleTypeToken(type);
    }

    public static <T> TypeTokenBuilder<T> builder(Class<T> type) {
        return new TypeTokenBuilder<T>(type);
    }

    public static <T> TypeToken<T> ofParameterized(Class<T> rawType, Class<?> ... parametrizedTypes) {
        TypeTokenBuilder<T> builder = TypeToken.builder(rawType);
        for (Class<?> parametrizedType : parametrizedTypes) {
            builder.parametrized(parametrizedType);
        }
        return builder.build();
    }

    public static <T> TypeToken<T> ofParameter(Parameter parameter) {
        return new SimpleTypeToken(parameter.getParameterizedType());
    }

    private static class SimpleTypeToken<T>
    extends TypeToken<T> {
        public SimpleTypeToken(Class<T> type) {
            super(type);
        }

        public SimpleTypeToken(Type type) {
            super(type);
        }
    }
}

