/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.type;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.IterableSuperClassResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.type.TypeRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class TypeIndex<T> {
    private final Map<Class<?>, T> sameIndex = new HashMap();
    private final Map<Class<?>, T> downwardIndex = new HashMap();
    private final Map<Class<?>, T> upwardIndex = new HashMap();

    public void put(TypeRange<?> range, T value) {
        if (range instanceof TypeRange.SameTypeRange) {
            TypeRange.SameTypeRange sameTypeRange = (TypeRange.SameTypeRange)range;
            this.sameIndex.put(sameTypeRange.getSame(), value);
            return;
        }
        if (range instanceof TypeRange.DownwardsTypeRange) {
            TypeRange.DownwardsTypeRange downwardsTypeRange = (TypeRange.DownwardsTypeRange)range;
            for (Class<?> aClass : downwardsTypeRange.getInclude()) {
                this.downwardIndex.put(aClass, value);
            }
            return;
        }
        if (range instanceof TypeRange.UpwardsTypeRange) {
            TypeRange.UpwardsTypeRange upwardsTypeRange = (TypeRange.UpwardsTypeRange)range;
            this.upwardIndex.put(upwardsTypeRange.getType(), value);
        }
    }

    public Iterable<T> get(Class<?> type) {
        return new TypeIterable(type);
    }

    public List<T> computeIfAbsent(TypeRange<?> range, Supplier<T> supplier) {
        if (range instanceof TypeRange.SameTypeRange) {
            TypeRange.SameTypeRange sameTypeRange = (TypeRange.SameTypeRange)range;
            Object value = this.sameIndex.computeIfAbsent(sameTypeRange.getSame(), (? super K k) -> supplier.get());
            return Collections.singletonList(value);
        }
        if (range instanceof TypeRange.DownwardsTypeRange) {
            TypeRange.DownwardsTypeRange downwardsTypeRange = (TypeRange.DownwardsTypeRange)range;
            ArrayList<Object> values = new ArrayList<Object>();
            for (Class<?> aClass : downwardsTypeRange.getInclude()) {
                Object value = this.downwardIndex.computeIfAbsent(aClass, (? super K k) -> supplier.get());
                values.add(value);
            }
            return values;
        }
        if (range instanceof TypeRange.UpwardsTypeRange) {
            TypeRange.UpwardsTypeRange upwardsTypeRange = (TypeRange.UpwardsTypeRange)range;
            Object value = this.upwardIndex.computeIfAbsent(upwardsTypeRange.getType(), (? super K k) -> supplier.get());
            return Collections.singletonList(value);
        }
        return Collections.emptyList();
    }

    private class TypeIterator
    implements Iterator<T> {
        private final Class<?> type;
        private boolean sameType = true;
        private boolean downwardsType = true;
        private boolean upwardsType = true;
        private Iterator<Class<?>> upwardIterator;
        private T next;

        private TypeIterator(Class<?> type) {
            this.type = type;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object t;
            Object next = this.next;
            this.next = null;
            if (this.sameType) {
                this.sameType = false;
                t = TypeIndex.this.sameIndex.get(this.type);
                if (t != null) {
                    this.next = t;
                    return next;
                }
            }
            if (this.downwardsType) {
                this.downwardsType = false;
                t = TypeIndex.this.downwardIndex.get(this.type);
                if (t != null) {
                    this.next = t;
                    return next;
                }
            }
            if (this.upwardsType) {
                this.upwardsType = false;
                this.upwardIterator = new IterableSuperClassResolver(this.type).iterator();
            }
            while (this.upwardIterator.hasNext()) {
                Class<?> nextType = this.upwardIterator.next();
                Object t2 = TypeIndex.this.upwardIndex.get(nextType);
                if (t2 == null) continue;
                this.next = t2;
                return next;
            }
            return next;
        }
    }

    private class TypeIterable
    implements Iterable<T> {
        private final Class<?> type;

        private TypeIterable(Class<?> type) {
            this.type = type;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new TypeIterator(this.type);
        }
    }
}

