/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.platform;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.CommandRoute;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.platform.Platform;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.platform.PlatformInvocationListener;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.platform.PlatformSettings;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.platform.PlatformSuggestionListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlatform<SENDER, C extends PlatformSettings>
implements Platform<SENDER, C> {
    @NotNull
    protected C settings;
    protected final Map<String, CommandRoute<SENDER>> commandRoutes = new HashMap<String, CommandRoute<SENDER>>();

    protected AbstractPlatform(@NotNull C settings) {
        this.settings = settings;
    }

    @Override
    public void setConfiguration(@NotNull C liteConfiguration) {
        this.settings = liteConfiguration;
    }

    @Override
    @NotNull
    public C getConfiguration() {
        return this.settings;
    }

    @Override
    public final void register(CommandRoute<SENDER> commandRoute, PlatformInvocationListener<SENDER> invocationHook, PlatformSuggestionListener<SENDER> suggestionHook) {
        for (String name : commandRoute.names()) {
            if (!this.commandRoutes.containsKey(name)) continue;
            throw new IllegalArgumentException("Command with name " + name + " already exists");
        }
        this.hook(commandRoute, invocationHook, suggestionHook);
        for (String name : commandRoute.names()) {
            this.commandRoutes.put(name, commandRoute);
        }
    }

    @Override
    public final void unregister(CommandRoute<SENDER> commandRoute) {
        this.unhook(commandRoute);
        for (String name : commandRoute.names()) {
            this.commandRoutes.remove(name);
        }
    }

    @Override
    public final void unregisterAll() {
        for (CommandRoute<SENDER> commandRoute : this.commandRoutes.values()) {
            this.unhook(commandRoute);
        }
        this.commandRoutes.clear();
    }

    protected abstract void hook(CommandRoute<SENDER> var1, PlatformInvocationListener<SENDER> var2, PlatformSuggestionListener<SENDER> var3);

    protected abstract void unhook(CommandRoute<SENDER> var1);
}

