/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.permission;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.Meta;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.MetaHolder;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.permission.MissingPermissions;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.permission.PermissionResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.permission.PermissionService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.platform.PlatformSender;

public class PermissionServiceImpl
implements PermissionService {
    private PermissionResolver permissionResolver = PermissionResolver.createDefault((sender, permission) -> {
        throw new UnsupportedOperationException("Your platform does not support permissions. Please provide a custom PermissionResolver.");
    });

    public PermissionServiceImpl() {
    }

    public PermissionServiceImpl(PermissionResolver permissionResolver) {
        this.permissionResolver = permissionResolver;
    }

    public void setPermissionResolver(PermissionResolver permissionResolver) {
        this.permissionResolver = permissionResolver;
    }

    @Override
    public MissingPermissions validate(PlatformSender sender, MetaHolder metaHolder) {
        return new MissingPermissions(this.permissionResolver.resolve(sender, metaHolder));
    }

    @Override
    public MissingPermissions validate(PlatformSender sender, Meta meta) {
        return new MissingPermissions(this.permissionResolver.resolve(sender, MetaHolder.of(meta)));
    }
}

