/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.permission;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecutorMatchResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.event.CommandExecutorFoundEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.event.CommandExecutorNotFoundEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.event.EventListener;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.event.Subscriber;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.permission.MissingPermissions;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.permission.PermissionService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.priority.PriorityLevel;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.FailedReason;

public class PermissionExecutionController
implements EventListener {
    private final PermissionService permissionService;

    public PermissionExecutionController(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Subscriber
    void onEvent(CommandExecutorFoundEvent<?> event) {
        MissingPermissions result = this.permissionService.validate(event.getInvocation().platformSender(), event.getExecutor());
        if (result.isPermitted()) {
            return;
        }
        boolean successful = event.getResult().isSuccessful();
        PriorityLevel priority = successful ? PriorityLevel.HIGH : PriorityLevel.NORMAL;
        event.setResult(CommandExecutorMatchResult.failed(FailedReason.of(result, priority)));
    }

    @Subscriber
    void onEvent(CommandExecutorNotFoundEvent event) {
        MissingPermissions result = this.permissionService.validate(event.getInvocation().platformSender(), event.getCommandRoute());
        if (result.isPermitted()) {
            return;
        }
        event.setFailedReason(FailedReason.of(result));
    }
}

