/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.message;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.cooldown.CooldownState;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.message.MessageKey;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.permission.MissingPermissions;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.time.DurationParser;

public class LiteMessages {
    public static final MessageKey<MissingPermissions> MISSING_PERMISSIONS = MessageKey.of("missing-permission", missingPermissions -> String.format("You don't have permission to execute this command! (%s) (MISSING_PERMISSIONS)", missingPermissions.asJoinedText()), new MessageKey[0]);
    public static final MessageKey<String> INVALID_NUMBER = MessageKey.of("invalid-number", input -> String.format("'%s' is not a number! (INVALID_NUMBER)", input), new MessageKey[0]);
    public static final MessageKey<InvalidUsage<?>> INVALID_USAGE = MessageKey.of("invalid-usage", invalidUsage -> "Invalid usage of command! (INVALID_USAGE)", new MessageKey[0]);
    public static final MessageKey<String> INSTANT_INVALID_FORMAT = MessageKey.of("instant-invalid-format", input -> "Invalid date format '" + input + "'! Use: <yyyy-MM-dd> <HH:mm:ss> (INSTANT_INVALID_FORMAT)", new MessageKey[0]);
    public static final MessageKey<CooldownState> COMMAND_COOLDOWN = MessageKey.of("command-cooldown", state -> "You are on cooldown! Remaining time: " + DurationParser.DATE_TIME_UNITS.format(state.getRemainingDuration()) + " (COMMAND_COOLDOWN)", new MessageKey[0]);
    public static final MessageKey<String> UUID_INVALID_FORMAT = MessageKey.of("uuid-invalid-format", input -> "Invalid UUID format '" + input + "'! Use: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx (dashes are optional) (UUID_INVALID_FORMAT)", new MessageKey[0]);

    protected LiteMessages() {
    }
}

