/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.input.raw;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.input.raw.RawInputView;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class RawInputViewFastImpl
implements RawInputView {
    protected final NavigableMap<Integer, Integer> claimedIndexes = new TreeMap<Integer, Integer>();
    protected final char[] sourceContentChars;
    protected final String sourceContent;
    @Nullable
    protected String notClaimedCache;
    protected final AtomicInteger subIdSequence = new AtomicInteger();
    protected final Map<Integer, String> notClaimedSubsCache = new HashMap<Integer, String>();

    public RawInputViewFastImpl(String content) {
        this.sourceContentChars = content.toCharArray();
        this.sourceContent = content;
        this.notClaimedCache = content;
    }

    @Override
    public String claim() {
        return this.claim(0, this.sourceContentChars.length);
    }

    @Override
    public String claim(int startInclusive, int endExclusive) {
        return this.sub(startInclusive, endExclusive).claim();
    }

    protected String internalClaim(int startInclusive, int endExclusive) {
        ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> newClaimedIndexes = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
        int toClaim = endExclusive - startInclusive;
        int lastBorderEnd = startInclusive;
        for (Map.Entry entry : this.claimedIndexes.entrySet()) {
            int n = (Integer)entry.getKey();
            int borderEnd = (Integer)entry.getValue();
            if (borderEnd <= startInclusive) continue;
            if (n >= endExclusive) break;
            if (toClaim > 0) {
                if ((toClaim -= n - lastBorderEnd) > 0) {
                    if (lastBorderEnd < n) {
                        newClaimedIndexes.add(new AbstractMap.SimpleEntry<Integer, Integer>(lastBorderEnd, n));
                    }
                } else {
                    newClaimedIndexes.add(new AbstractMap.SimpleEntry<Integer, Integer>(lastBorderEnd, n + toClaim));
                }
            }
            toClaim -= borderEnd - n;
            lastBorderEnd = borderEnd;
        }
        if (toClaim > 0) {
            newClaimedIndexes.add(new AbstractMap.SimpleEntry<Integer, Integer>(lastBorderEnd, lastBorderEnd + toClaim));
        }
        for (Map.Entry entry : newClaimedIndexes) {
            Map.Entry<Integer, Integer> higherEntry;
            int n = (Integer)entry.getKey();
            int end = (Integer)entry.getValue();
            Map.Entry<Integer, Integer> lowerEntry = this.claimedIndexes.lowerEntry(n + 1);
            if (lowerEntry != null && lowerEntry.getValue() >= n) {
                n = lowerEntry.getKey();
                this.claimedIndexes.remove(lowerEntry.getKey());
            }
            if ((higherEntry = this.claimedIndexes.higherEntry(end - 1)) != null && higherEntry.getKey() <= end) {
                end = higherEntry.getValue();
                this.claimedIndexes.remove(higherEntry.getKey());
            }
            this.claimedIndexes.put(n, end);
        }
        this.notClaimedSubsCache.clear();
        this.notClaimedCache = null;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : newClaimedIndexes) {
            builder.append(this.sourceContent, (int)((Integer)entry.getKey()), (int)((Integer)entry.getValue()));
        }
        return builder.toString();
    }

    @Override
    public String content() {
        if (this.notClaimedCache != null) {
            return this.notClaimedCache;
        }
        this.notClaimedCache = this.rerenderContent();
        return this.notClaimedCache;
    }

    private String rerenderContent() {
        if (this.claimedIndexes.isEmpty()) {
            return this.sourceContent;
        }
        char[] result = new char[this.sourceContent.length()];
        int lastSaved = 0;
        int lastNotClaimed = 0;
        for (Map.Entry entry : this.claimedIndexes.entrySet()) {
            int start = (Integer)entry.getKey();
            System.arraycopy(this.sourceContentChars, lastNotClaimed, result, lastSaved, start - lastNotClaimed);
            lastSaved += start - lastNotClaimed;
            lastNotClaimed = (Integer)entry.getValue();
        }
        System.arraycopy(this.sourceContentChars, lastNotClaimed, result, lastSaved, this.sourceContentChars.length - lastNotClaimed);
        if ((lastSaved += this.sourceContentChars.length - lastNotClaimed) < result.length) {
            result = Arrays.copyOf(result, lastSaved);
        }
        return new String(result);
    }

    @Override
    public RawInputView sub(int startInclusive, int endExclusive) {
        if (startInclusive > endExclusive) {
            throw new IllegalArgumentException("Invalid 'start' and 'end', expected: [start <= end] but got: [" + startInclusive + " <= " + endExclusive + "]");
        }
        if (startInclusive < 0) {
            throw new IllegalArgumentException("Invalid 'start', expected: [start >= 0] but got: [" + startInclusive + "]");
        }
        if (endExclusive > this.sourceContentChars.length) {
            throw new IllegalArgumentException("Invalid 'end', expected: [start <= end <= length] but got: [" + startInclusive + " <= " + endExclusive + " <= " + this.sourceContentChars.length + "]");
        }
        int claimedBefore = this.claimedCount(0, startInclusive);
        int claimedInside = this.claimedCount(startInclusive, endExclusive);
        return new RawInputSubView(claimedBefore + startInclusive, claimedBefore + claimedInside + endExclusive);
    }

    private int claimedCount(int startInclusive, int endExclusive) {
        int count = 0;
        for (Map.Entry entry : this.claimedIndexes.entrySet()) {
            if ((Integer)entry.getValue() <= startInclusive) continue;
            if ((Integer)entry.getKey() >= endExclusive) break;
            count += (Integer)entry.getValue() - (Integer)entry.getKey() - Math.max(0, startInclusive - (Integer)entry.getKey());
        }
        return count;
    }

    @Override
    public RawInputView sub(int startInclusive) {
        return this.sub(startInclusive, this.sourceContentChars.length);
    }

    @Override
    public int countOf(char character) {
        String content = this.content();
        int count = 0;
        for (int i = 0; i < content.length(); ++i) {
            if (content.charAt(i) != character) continue;
            ++count;
        }
        return count;
    }

    @Override
    public String sourceContent() {
        return this.sourceContent;
    }

    private class RawInputSubView
    implements RawInputView {
        private final Integer id;
        private final int internalFrom;
        private final int internalTo;
        private final String sourceContent;

        public RawInputSubView(int internalFrom, int internalTo) {
            this.id = RawInputViewFastImpl.this.subIdSequence.getAndIncrement();
            this.internalFrom = internalFrom;
            this.internalTo = internalTo;
            this.sourceContent = RawInputViewFastImpl.this.sourceContent.substring(internalFrom, internalTo);
        }

        @Override
        public String content() {
            String subContent = RawInputViewFastImpl.this.notClaimedSubsCache.get(this.id);
            if (subContent != null) {
                return subContent;
            }
            String content = this.renderContent();
            RawInputViewFastImpl.this.notClaimedSubsCache.put(this.id, content);
            return content;
        }

        private String renderContent() {
            if (RawInputViewFastImpl.this.claimedIndexes.isEmpty()) {
                return this.sourceContent();
            }
            char[] result = new char[this.internalTo - this.internalFrom];
            int lastSaved = 0;
            int skiped = 0;
            int lastBorderEnd = this.internalFrom;
            for (Map.Entry entry : RawInputViewFastImpl.this.claimedIndexes.entrySet()) {
                int start = Math.max((Integer)entry.getKey(), this.internalFrom);
                int end = (Integer)entry.getValue();
                if (end <= this.internalFrom) {
                    lastBorderEnd = end;
                    continue;
                }
                if (start >= this.internalTo) break;
                int length = start - lastBorderEnd;
                System.arraycopy(RawInputViewFastImpl.this.sourceContentChars, lastBorderEnd, result, lastBorderEnd - this.internalFrom, length);
                lastSaved += length;
                skiped = end - start;
                lastBorderEnd = end;
            }
            int lengthCopy = this.internalTo - this.internalFrom - lastSaved - skiped;
            System.arraycopy(RawInputViewFastImpl.this.sourceContentChars, lastBorderEnd, result, lastSaved, lengthCopy);
            if ((lastSaved += lengthCopy) < result.length) {
                result = Arrays.copyOf(result, lastSaved);
            }
            return new String(result);
        }

        @Override
        public RawInputView sub(int startInclusive, int endExclusive) {
            if (startInclusive > endExclusive) {
                throw new IllegalArgumentException("Invalid 'start' and 'end', expected: [start <= end] but got: [" + startInclusive + " <= " + endExclusive + "]");
            }
            if (startInclusive < 0) {
                throw new IllegalArgumentException("Invalid 'start', expected: [start >= 0] but got: [" + startInclusive + "]");
            }
            if (endExclusive > this.internalTo - this.internalFrom) {
                throw new IllegalArgumentException("Invalid 'end', expected: [start <= end <= length] but got: [" + startInclusive + " <= " + endExclusive + " <= " + (this.internalTo - this.internalFrom) + "]");
            }
            int claimedBefore = RawInputViewFastImpl.this.claimedCount(this.internalFrom, this.internalFrom + startInclusive);
            int claimedInside = RawInputViewFastImpl.this.claimedCount(this.internalFrom + startInclusive, this.internalFrom + endExclusive);
            return new RawInputSubView(this.internalFrom + claimedBefore + startInclusive, this.internalFrom + claimedBefore + claimedInside + endExclusive);
        }

        @Override
        public RawInputView sub(int startInclusive) {
            return this.sub(startInclusive, this.internalTo - this.internalFrom);
        }

        @Override
        public int countOf(char character) {
            String content = this.content();
            int count = 0;
            for (int i = 0; i < content.length(); ++i) {
                if (content.charAt(i) != character) continue;
                ++count;
            }
            return count;
        }

        @Override
        public String sourceContent() {
            return this.sourceContent;
        }

        @Override
        public String claim() {
            return RawInputViewFastImpl.this.internalClaim(this.internalFrom, this.internalTo);
        }

        @Override
        public String claim(int startInclusive, int endExclusive) {
            return this.sub(startInclusive, endExclusive).claim();
        }
    }
}

