/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.cooldown;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecutor;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.cooldown.CooldownCompositeKey;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.cooldown.CooldownContext;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.cooldown.CooldownState;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.cooldown.event.CooldownApiEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.cooldown.event.CooldownCommandEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.cooldown.event.CooldownEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.event.EventPublisher;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.identifier.Identifier;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.Meta;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.permission.PermissionService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.platform.PlatformSender;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler.Scheduler;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler.SchedulerType;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class CooldownService {
    private final Scheduler scheduler;
    private final PermissionService permissionService;
    private final EventPublisher publisher;
    private final Map<CooldownCompositeKey, CooldownState> cooldowns = new HashMap<CooldownCompositeKey, CooldownState>();

    public CooldownService(Scheduler scheduler, PermissionService permissionService, EventPublisher publisher) {
        this.scheduler = scheduler;
        this.permissionService = permissionService;
        this.publisher = publisher;
    }

    public Optional<CooldownState> getCooldown(CommandExecutor<?> executor, PlatformSender sender) {
        return this.getOperativeContext(executor, sender).flatMap(cooldownContext -> this.getCooldown(cooldownContext.getKey(), sender.getIdentifier()));
    }

    public Optional<CooldownState> getCooldown(String key, Identifier senderIdentifier) {
        CooldownCompositeKey compositeKey = new CooldownCompositeKey(senderIdentifier, key);
        CooldownState cooldownState = this.cooldowns.get(compositeKey);
        if (cooldownState != null && !cooldownState.isExpired()) {
            return Optional.of(cooldownState);
        }
        return Optional.empty();
    }

    public Optional<CooldownState> markCooldown(Invocation<?> invocation, CommandExecutor<?> executor) {
        return this.getOperativeContext(executor, invocation.platformSender()).map(context -> new CooldownCommandEvent(invocation, context.getKey(), context.getDuration())).flatMap(event -> this.processChange((CooldownEvent)event));
    }

    public Optional<CooldownState> markCooldown(CooldownContext context, Identifier senderIdentifier) {
        return this.processChange(new CooldownApiEvent(senderIdentifier, context.getKey(), context.getDuration()));
    }

    private Optional<CooldownState> processChange(CooldownEvent event) {
        CooldownEvent publishedEvent = this.publisher.publish(event);
        if (publishedEvent.isCancelled()) {
            return Optional.empty();
        }
        CooldownCompositeKey compositeKey = new CooldownCompositeKey(publishedEvent.getSender(), publishedEvent.getKey());
        Duration duration = publishedEvent.getDuration();
        CooldownState state = new CooldownState(publishedEvent.getKey(), duration);
        this.cooldowns.put(compositeKey, state);
        this.scheduler.supplyLater(SchedulerType.MAIN, duration, () -> this.cooldowns.remove(compositeKey));
        return Optional.of(state);
    }

    public boolean removeCooldown(String key, Identifier senderIdentifier) {
        CooldownCompositeKey compositeKey = new CooldownCompositeKey(senderIdentifier, key);
        return this.cooldowns.remove(compositeKey) != null;
    }

    private Optional<CooldownContext> getOperativeContext(CommandExecutor<?> executor, PlatformSender sender) {
        CooldownContext context = executor.metaCollector().findFirst(Meta.COOLDOWN, null);
        if (context == null) {
            return Optional.empty();
        }
        if (!context.getBypassPermission().isEmpty() && this.permissionService.isPermitted(sender, context.getPermissions())) {
            return Optional.empty();
        }
        return Optional.of(context);
    }
}

