/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.context;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.context.AsyncContextResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.context.ContextCompletedResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.RequirementCondition;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.RequirementFutureResult;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public interface ContextResult<T>
extends RequirementFutureResult<T> {
    @Override
    public CompletableFuture<ContextCompletedResult<T>> asFuture();

    @ApiStatus.Experimental
    public <R> ContextResult<R> map(Function<T, R> var1);

    @ApiStatus.Experimental
    public ContextResult<T> mapFailure(Function<Object, ContextResult<T>> var1);

    @ApiStatus.Experimental
    public <R> ContextResult<R> flatMap(Function<T, ContextResult<R>> var1);

    @ApiStatus.Experimental
    public ContextResult<T> whenSuccessful(Consumer<T> var1);

    @ApiStatus.Experimental
    public ContextResult<T> whenFailed(Consumer<Object> var1);

    public static <T> ContextCompletedResult<T> ok(Supplier<T> supplier) {
        return new ContextCompletedResult<T>(supplier, null, Collections.emptyList());
    }

    public static <T> ContextCompletedResult<T> error(Object error) {
        return new ContextCompletedResult(null, error, Collections.emptyList());
    }

    @ApiStatus.Experimental
    public static <T> ContextResult<T> conditional(Supplier<T> supplier, List<RequirementCondition> conditions) {
        return new ContextCompletedResult<T>(supplier, null, Collections.unmodifiableList(conditions));
    }

    @ApiStatus.Experimental
    public static <T> AsyncContextResult<T> completableFuture(CompletableFuture<ContextResult<T>> future) {
        return new AsyncContextResult<T>(future);
    }

    @ApiStatus.Experimental
    public static <T, EXPECTED> AsyncContextResult<EXPECTED> completableFuture(CompletableFuture<T> future, Function<T, ? extends ContextResult<EXPECTED>> mapper) {
        return new AsyncContextResult(future.thenApply(mapper));
    }

    @ApiStatus.Experimental
    public static <EXPECTED> AsyncContextResult<EXPECTED> async(Supplier<? extends ContextResult<EXPECTED>> supplier) {
        return new AsyncContextResult(CompletableFuture.supplyAsync(supplier));
    }

    @ApiStatus.Experimental
    public static <EXPECTED> AsyncContextResult<EXPECTED> async(Supplier<? extends ContextResult<EXPECTED>> supplier, Executor executor) {
        return new AsyncContextResult(CompletableFuture.supplyAsync(supplier, executor));
    }
}

