/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.LiteCommandsException;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.input.ParseableInputMatcher;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.CommandRoute;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecuteResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecutor;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecutorMatchResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.LastExceptionHandler;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.event.CommandExecutorFoundEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.event.CommandExecutorNotFoundEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.event.CommandPostExecutionEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.event.CommandPreExecutionEvent;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.event.EventPublisher;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.handler.result.ResultHandleService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invalidusage.InvalidUsageException;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.priority.MutablePrioritizedList;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.priority.PriorityLevel;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.RequirementMatchService;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler.Scheduler;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scheduler.SchedulerType;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.FailedReason;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class CommandExecuteService<SENDER> {
    private final ResultHandleService<SENDER> resultResolver;
    private final Scheduler scheduler;
    private final RequirementMatchService<SENDER> requirementMatchService;
    private final EventPublisher publisher;

    public CommandExecuteService(ResultHandleService<SENDER> resultResolver, Scheduler scheduler, RequirementMatchService<SENDER> requirementMatchService, EventPublisher publisher) {
        this.resultResolver = resultResolver;
        this.scheduler = scheduler;
        this.requirementMatchService = requirementMatchService;
        this.publisher = publisher;
    }

    public CompletableFuture<CommandExecuteResult> execute(Invocation<SENDER> invocation, ParseableInputMatcher<?> matcher, CommandRoute<SENDER> commandRoute) {
        return ((CompletableFuture)((CompletableFuture)this.execute0(invocation, matcher, commandRoute).thenApply(result -> this.publishAndApplyEvent(invocation, commandRoute, (CommandExecuteResult)result))).thenCompose(executeResult -> this.scheduler.supply(SchedulerType.MAIN, () -> this.handleResult(invocation, (CommandExecuteResult)executeResult)))).exceptionally(new LastExceptionHandler<SENDER>(this.resultResolver, invocation));
    }

    private CommandExecuteResult publishAndApplyEvent(Invocation<SENDER> invocation, CommandRoute<SENDER> route, CommandExecuteResult result) {
        if (this.publisher.hasSubscribers(CommandPostExecutionEvent.class)) {
            CommandExecutor<?> executor = result.getExecutor();
            result = this.publisher.publish(new CommandPostExecutionEvent<SENDER>(invocation, route, executor, result)).getResult();
        }
        return result;
    }

    private CommandExecuteResult handleResult(Invocation<SENDER> invocation, CommandExecuteResult executeResult) {
        Object error;
        Object result;
        Throwable throwable = executeResult.getThrowable();
        if (throwable != null) {
            this.resultResolver.resolve(invocation, throwable);
        }
        if ((result = executeResult.getResult()) != null) {
            this.resultResolver.resolve(invocation, result);
        }
        if ((error = executeResult.getError()) != null) {
            this.resultResolver.resolve(invocation, error);
        }
        return executeResult;
    }

    private <MATCHER extends ParseableInputMatcher<MATCHER>> CompletableFuture<CommandExecuteResult> execute0(Invocation<SENDER> invocation, ParseableInputMatcher<MATCHER> matcher, CommandRoute<SENDER> commandRoute) {
        return this.execute(commandRoute.getExecutors().iterator(), invocation, matcher, commandRoute, new MutablePrioritizedList<FailedReason>());
    }

    private <MATCHER extends ParseableInputMatcher<MATCHER>> CompletableFuture<CommandExecuteResult> execute(Iterator<CommandExecutor<SENDER>> executors, Invocation<SENDER> invocation, ParseableInputMatcher<MATCHER> matcher, CommandRoute<SENDER> commandRoute, MutablePrioritizedList<FailedReason> failedReasons) {
        if (!executors.hasNext()) {
            if (commandRoute.getExecutors().isEmpty()) {
                failedReasons.add(FailedReason.of((Object)InvalidUsage.Cause.UNKNOWN_COMMAND, PriorityLevel.LOW));
            }
            CommandExecutorNotFoundEvent event = this.publisher.publish(new CommandExecutorNotFoundEvent(invocation, commandRoute, failedReasons));
            return CompletableFuture.completedFuture(CommandExecuteResult.failed(event.getFailedReason().getReason()));
        }
        CommandExecutor<SENDER> executor = executors.next();
        return ((CompletableFuture)this.requirementMatchService.match(executor, invocation, matcher.copy()).thenCompose(match -> {
            CommandExecutorFoundEvent matchEvent = this.publisher.publish(new CommandExecutorFoundEvent(invocation, executor, (CommandExecutorMatchResult)match));
            if (matchEvent.isCancelled()) {
                return CompletableFuture.completedFuture(CommandExecuteResult.failed(executor, matchEvent.getCancelReason()));
            }
            CommandExecutorMatchResult processedMatch = matchEvent.getResult();
            if (processedMatch.isFailed()) {
                failedReasons.add(processedMatch.getFailedReason());
                return this.execute(executors, invocation, matcher, commandRoute, failedReasons);
            }
            CommandPreExecutionEvent executionEvent = this.publisher.publish(new CommandPreExecutionEvent(invocation, executor));
            if (executionEvent.isCancelled()) {
                return CompletableFuture.completedFuture(CommandExecuteResult.failed(executor, executionEvent.getCancelReason()));
            }
            return this.scheduler.supply(executionEvent.getSchedulerType(), () -> this.execute(processedMatch, executor));
        })).exceptionally(throwable -> this.toThrown(executor, (Throwable)throwable));
    }

    private CommandExecuteResult toThrown(CommandExecutor<SENDER> executor, Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return CommandExecuteResult.thrown(executor, throwable.getCause());
        }
        return CommandExecuteResult.thrown(executor, throwable);
    }

    private CommandExecuteResult execute(CommandExecutorMatchResult match, CommandExecutor<SENDER> executor) {
        try {
            return match.executeCommand();
        }
        catch (LiteCommandsException exception) {
            if (exception.getCause() instanceof InvalidUsageException) {
                return CommandExecuteResult.failed(executor, ((InvalidUsageException)exception.getCause()).getErrorResult());
            }
            return CommandExecuteResult.thrown(executor, exception);
        }
        catch (Throwable error) {
            return CommandExecuteResult.thrown(executor, error);
        }
    }
}

