/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.CommandNode;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.CommandRootRouteImpl;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.CommandRouteImpl;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.command.executor.CommandExecutor;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.meta.Meta;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.priority.PrioritizedList;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.scope.Scopeable;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;

public interface CommandRoute<SENDER>
extends Scopeable,
CommandNode<SENDER> {
    public String getName();

    public UUID getUniqueId();

    public @Unmodifiable List<String> getAliases();

    public @Unmodifiable List<String> names();

    @Contract(value="null -> false; !null -> _")
    public boolean isNameOrAlias(String var1);

    @Override
    public CommandRoute<SENDER> getParent();

    default public boolean isRoot() {
        return false;
    }

    default public boolean isReference() {
        return false;
    }

    public void appendChildren(CommandRoute<SENDER> var1);

    public @Unmodifiable List<CommandRoute<SENDER>> getChildren();

    public Optional<CommandRoute<SENDER>> getChild(String var1);

    public void appendExecutor(CommandExecutor<SENDER> var1);

    public @Unmodifiable PrioritizedList<CommandExecutor<SENDER>> getExecutors();

    @Override
    public Meta meta();

    public static <SENDER> CommandRoute<SENDER> create(CommandRoute<SENDER> parent, String name, List<String> aliases) {
        return new CommandRouteImpl<SENDER>(name, aliases, parent);
    }

    public static <SENDER> CommandRoute<SENDER> createRoot() {
        return new CommandRootRouteImpl();
    }

    @ApiStatus.Experimental
    public CommandRoute<SENDER> merge(CommandRoute<SENDER> var1);
}

