/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.argument;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.LiteBukkitMessages;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.message.MessageRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class OfflinePlayerArgument
extends ArgumentResolver<CommandSender, OfflinePlayer> {
    private static final int SUGGESTION_LIMIT = 256;
    private final Server server;
    private final MessageRegistry<CommandSender> messageRegistry;
    private final boolean allowParseUnknownPlayers;
    private final Pattern playerNamePattern;
    private final TreeSet<String> nicknames = new TreeSet(String.CASE_INSENSITIVE_ORDER);

    public OfflinePlayerArgument(Server server, Plugin plugin, MessageRegistry<CommandSender> messageRegistry, boolean allowParseUnknownPlayers, Pattern playerNamePattern) {
        this.server = server;
        this.messageRegistry = messageRegistry;
        this.allowParseUnknownPlayers = allowParseUnknownPlayers;
        this.playerNamePattern = playerNamePattern;
        Bukkit.getScheduler().runTask(plugin, () -> {
            this.nicknames.clear();
            for (OfflinePlayer player : server.getOfflinePlayers()) {
                String name = player.getName();
                if (name == null) continue;
                this.nicknames.add(name);
            }
        });
        server.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerJoin(PlayerJoinEvent event) {
                OfflinePlayerArgument.this.nicknames.add(event.getPlayer().getName());
            }
        }, plugin);
    }

    @Override
    protected ParseResult<OfflinePlayer> parse(Invocation<CommandSender> invocation, Argument<OfflinePlayer> context, String argument) {
        return ParseResult.async(() -> {
            OfflinePlayer offlinePlayer = this.server.getOfflinePlayer(argument);
            long firstPlayed = offlinePlayer.getFirstPlayed();
            if (firstPlayed < 1L && !this.allowParseUnknownPlayers) {
                return ParseResult.failure(this.messageRegistry.get(LiteBukkitMessages.OFFLINE_PLAYER_NOT_FOUND, invocation, argument));
            }
            return ParseResult.success(offlinePlayer);
        });
    }

    @Override
    protected boolean match(Invocation<CommandSender> invocation, Argument<OfflinePlayer> context, String argument) {
        return this.playerNamePattern.matcher(argument).matches();
    }

    @Override
    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<OfflinePlayer> argument, SuggestionContext context) {
        if (this.nicknames.size() < 256) {
            return SuggestionResult.of(this.nicknames);
        }
        String input = context.getCurrent().multilevel();
        if (input.isEmpty()) {
            return this.nicknames.stream().limit(256L).collect(SuggestionResult.collector());
        }
        return this.nicknames.subSet(input, input + '\uffff').stream().limit(256L).collect(SuggestionResult.collector());
    }
}

