/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.argument;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.LiteBukkitMessages;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.message.MessageRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class NamespacedKeyArgument
extends ArgumentResolver<CommandSender, NamespacedKey> {
    private final Plugin plugin;
    private final MessageRegistry<CommandSender> messageRegistry;

    public NamespacedKeyArgument(Plugin plugin, MessageRegistry<CommandSender> messageRegistry) {
        this.plugin = plugin;
        this.messageRegistry = messageRegistry;
    }

    @Override
    protected ParseResult<NamespacedKey> parse(Invocation<CommandSender> invocation, Argument<NamespacedKey> context, String argument) {
        NamespacedKey parsed = NamespacedKey.fromString((String)argument);
        if (parsed == null) {
            return ParseResult.failure(this.messageRegistry.get(LiteBukkitMessages.NAMESPACED_KEY_INVALID, invocation, argument));
        }
        return ParseResult.success(parsed);
    }

    @Override
    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<NamespacedKey> argument, SuggestionContext context) {
        String pluginName = this.plugin.getName().toLowerCase(Locale.ROOT).replace(" ", "-");
        return SuggestionResult.of("namespace:key", pluginName + ":key");
    }
}

