/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.BukkitCommandsRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.BukkitCommandsRegistryImpl;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.TabComplete;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.platform.PlatformSettings;
import java.util.regex.Pattern;
import org.bukkit.Server;

public class LiteBukkitSettings
implements PlatformSettings {
    private String fallbackPrefix = "";
    private boolean nativePermission = false;
    private boolean syncSuggestionWarning = true;
    private Pattern playerNamePattern = Pattern.compile("^[a-zA-Z0-9_]{3,16}$");
    private boolean allowParseUnknownPlayers = false;
    private BukkitCommandsRegistry commandsRegistry;
    private TabComplete tabCompleter;

    public LiteBukkitSettings(BukkitCommandsRegistry commandsRegistry) {
        this.commandsRegistry = commandsRegistry;
    }

    public LiteBukkitSettings(Server server) {
        this.commandsRegistry = BukkitCommandsRegistryImpl.create(server);
    }

    public LiteBukkitSettings fallbackPrefix(String fallbackPrefix) {
        this.fallbackPrefix = fallbackPrefix;
        return this;
    }

    public LiteBukkitSettings nativePermissions(boolean nativePermission) {
        this.nativePermission = nativePermission;
        return this;
    }

    public LiteBukkitSettings syncSuggestionWarning(boolean syncSuggestionWarning) {
        this.syncSuggestionWarning = syncSuggestionWarning;
        return this;
    }

    public LiteBukkitSettings playerNamePattern(Pattern playerNamePattern) {
        this.playerNamePattern = playerNamePattern;
        return this;
    }

    public LiteBukkitSettings allowParseUnknownPlayers(boolean allowParseUnknownPlayers) {
        this.allowParseUnknownPlayers = allowParseUnknownPlayers;
        return this;
    }

    public LiteBukkitSettings commandsRegistry(BukkitCommandsRegistry commandsRegistry) {
        this.commandsRegistry = commandsRegistry;
        return this;
    }

    public LiteBukkitSettings tabCompleter(TabComplete tabCompleter) {
        this.tabCompleter = tabCompleter;
        return this;
    }

    String getFallbackPrefix() {
        return this.fallbackPrefix;
    }

    boolean isNativePermissionEnabled() {
        return this.nativePermission;
    }

    boolean isSyncSuggestionWarning() {
        return this.syncSuggestionWarning;
    }

    Pattern getPlayerNamePattern() {
        return this.playerNamePattern;
    }

    boolean isParseUnknownPlayersAllowed() {
        return this.allowParseUnknownPlayers;
    }

    BukkitCommandsRegistry getCommandsRegistry() {
        return this.commandsRegistry;
    }

    TabComplete getTabCompleter() {
        return this.tabCompleter;
    }
}

