/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bind;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.Preconditions;

public final class BindResult<T> {
    private final T success;
    private final String error;

    private BindResult(T success, String error) {
        this.success = success;
        this.error = error;
    }

    public boolean isOk() {
        return this.success != null;
    }

    public boolean isError() {
        return this.error != null;
    }

    public T getSuccess() {
        Preconditions.checkArgument(this.isOk(), "Cannot get success value from error result", new Object[0]);
        return this.success;
    }

    public String getError() {
        Preconditions.checkArgument(this.isError(), "Cannot get error value from success result", new Object[0]);
        return this.error;
    }

    public static <T> BindResult<T> ok(T success) {
        Preconditions.notNull(success, "Success cannot be null");
        return new BindResult<T>(success, null);
    }

    public static <T> BindResult<T> error(String error) {
        Preconditions.notNull(error, "Error cannot be null");
        return new BindResult<Object>(null, error);
    }
}

