/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.suggester.input;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import org.jetbrains.annotations.Nullable;

public class SuggestionInputResult {
    private final Cause cause;
    @Nullable
    private final SuggestionResult result;

    private SuggestionInputResult(Cause cause, @Nullable SuggestionResult result) {
        this.cause = cause;
        this.result = result;
    }

    public SuggestionResult getResult() {
        return this.result == null ? SuggestionResult.empty() : this.result;
    }

    public Cause getCause() {
        return this.cause;
    }

    public boolean isContinue() {
        return this.cause == Cause.CONTINUE;
    }

    public boolean isEnd() {
        return this.cause == Cause.END;
    }

    public boolean isFail() {
        return this.cause == Cause.FAIL;
    }

    public static SuggestionInputResult continueWith(SuggestionResult result) {
        return new SuggestionInputResult(Cause.CONTINUE, result);
    }

    public static SuggestionInputResult continueWith(SuggestionInputResult result) {
        return new SuggestionInputResult(Cause.CONTINUE, result.getResult());
    }

    public static SuggestionInputResult continueWithout() {
        return new SuggestionInputResult(Cause.CONTINUE, null);
    }

    public static SuggestionInputResult endWith(SuggestionResult result) {
        return new SuggestionInputResult(Cause.END, result);
    }

    public static SuggestionInputResult fail() {
        return new SuggestionInputResult(Cause.FAIL, null);
    }

    public static enum Cause {
        CONTINUE,
        END,
        FAIL;

    }
}

