/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.suggester;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.ArgumentKey;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.suggester.Suggester;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.suggester.SuggesterChainAccessor;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.suggester.SuggesterChained;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.suggester.SuggesterRegistry;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.type.TypeIndex;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.reflect.type.TypeRange;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.BiHashMap;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.BiMap;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SuggesterRegistryImpl<SENDER>
implements SuggesterRegistry<SENDER>,
SuggesterChainAccessor<SENDER> {
    private final TypeIndex<BucketByArgument<?>> buckets = new TypeIndex();

    @Override
    public <T> void registerSuggester(TypeRange<T> type, ArgumentKey key, Suggester<SENDER, T> suggester) {
        List<BucketByArgument> bucketByArguments = this.buckets.computeIfAbsent(type, () -> new BucketByArgument());
        Iterator<BucketByArgument> iterator = bucketByArguments.iterator();
        while (iterator.hasNext()) {
            BucketByArgument bucketByArgument;
            BucketByArgument bucket = bucketByArgument = iterator.next();
            bucket.registerSuggester(type, key, suggester);
        }
    }

    @Override
    public <T> void registerSuggester(TypeRange<T> type, ArgumentKey key, SuggesterChained<SENDER, T> suggester) {
        this.registerSuggester(type, key, (Invocation<SENDER> invocation, Argument<T> argument, SuggestionContext context) -> suggester.suggest(invocation, argument, context, this));
    }

    @Override
    public <PARSED> List<Suggester<SENDER, PARSED>> getSuggesters(Class<PARSED> parsedClass, ArgumentKey key) {
        Iterable<BucketByArgument<?>> typedBuckets = this.buckets.get(parsedClass);
        ArrayList<Suggester<SENDER, PARSED>> suggesters = new ArrayList<Suggester<SENDER, PARSED>>();
        for (BucketByArgument<?> typedBucket : typedBuckets) {
            BucketByArgument<?> bucket = typedBucket;
            Suggester suggester = bucket.getSuggester(key);
            if (suggester == null) continue;
            suggesters.add(suggester);
        }
        return suggesters;
    }

    @Override
    public <T> SuggestionResult suggest(Invocation<SENDER> invocation, Argument<T> argument, SuggestionContext context) {
        Class parsedType = argument.getType().getRawType();
        Suggester<SENDER, T> suggester = this.getSuggester(parsedType, argument.getKey());
        return suggester.suggest(invocation, argument, context);
    }

    private class BucketByArgumentUniversal<PARSED> {
        private final BiMap<String, String, Suggester<SENDER, PARSED>> buckets = new BiHashMap();
        private final boolean ignoreNamespace;

        private BucketByArgumentUniversal(boolean ignoreNamespace) {
            this.ignoreNamespace = ignoreNamespace;
        }

        void registerSuggester(TypeRange<PARSED> parsedType, ArgumentKey key, Suggester<SENDER, PARSED> parser) {
            this.buckets.put(key.getKey(), key.getNamespace(), parser);
        }

        @Nullable
        Suggester<SENDER, PARSED> getSuggester(ArgumentKey key) {
            String namespace = this.ignoreNamespace ? ArgumentKey.DEFAULT_NAMESPACE : key.getNamespace();
            Suggester bucket = this.buckets.get(key.getKey(), namespace);
            if (bucket != null) {
                return bucket;
            }
            return this.buckets.get("", namespace);
        }
    }

    private class BucketByArgument<PARSED>
    extends BucketByArgumentUniversal<PARSED> {
        private final BucketByArgumentUniversal<PARSED> universalTypedBucket;

        private BucketByArgument() {
            super(false);
            this.universalTypedBucket = new BucketByArgumentUniversal(true);
        }

        @Override
        void registerSuggester(TypeRange<PARSED> parsedType, ArgumentKey key, Suggester<SENDER, PARSED> parser) {
            if (key.isDefaultNamespace()) {
                this.universalTypedBucket.registerSuggester(parsedType, key, parser);
                return;
            }
            super.registerSuggester(parsedType, key, parser);
        }

        @Override
        @Nullable
        Suggester<SENDER, PARSED> getSuggester(ArgumentKey key) {
            Suggester bucket = super.getSuggester(key);
            if (bucket != null) {
                return bucket;
            }
            return this.universalTypedBucket.getSuggester(key);
        }
    }
}

