/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.standard;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EnumArgumentResolver<SENDER>
extends ArgumentResolver<SENDER, Enum> {
    private final Map<Class<Enum>, SuggestionResult> cachedEnumSuggestions = new ConcurrentHashMap<Class<Enum>, SuggestionResult>();

    @Override
    protected ParseResult<Enum> parse(Invocation<SENDER> invocation, Argument<Enum> context, String argument) {
        Class enumClass = context.getType().getRawType();
        try {
            return ParseResult.success(this.getEnum(enumClass, argument));
        }
        catch (IllegalArgumentException ignored) {
            return ParseResult.failure((Object)InvalidUsage.Cause.INVALID_ARGUMENT);
        }
    }

    @Override
    public SuggestionResult suggest(Invocation<SENDER> invocation, Argument<Enum> argument, SuggestionContext context) {
        Class enumClass = argument.getType().getRawType();
        return this.cachedEnumSuggestions.computeIfAbsent(enumClass, key -> {
            Enum[] enums = (Enum[])enumClass.getEnumConstants();
            if (enums == null || enums.length == 0) {
                return SuggestionResult.empty();
            }
            return Arrays.stream(enums).map(anEnum -> anEnum.name()).collect(SuggestionResult.collector());
        });
    }

    private Enum getEnum(Class<? extends Enum> clazz, String name) throws IllegalArgumentException {
        return Enum.valueOf(clazz, name);
    }
}

