/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser;

import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseAsyncResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.argument.parser.ParseCompletedResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.RequirementCondition;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.requirement.RequirementFutureResult;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.shared.FailedReason;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.UnknownNullability;

public interface ParseResult<EXCEPTED>
extends RequirementFutureResult<EXCEPTED> {
    @Override
    public CompletableFuture<ParseCompletedResult<EXCEPTED>> asFuture();

    @ApiStatus.Experimental
    public <R> ParseResult<R> map(Function<EXCEPTED, R> var1);

    @ApiStatus.Experimental
    public ParseResult<EXCEPTED> mapFailure(Function<Object, ParseResult<EXCEPTED>> var1);

    @ApiStatus.Experimental
    public <R> ParseResult<R> flatMap(Function<EXCEPTED, ParseResult<R>> var1);

    @ApiStatus.Experimental
    public ParseResult<EXCEPTED> whenSuccessful(Consumer<EXCEPTED> var1);

    @ApiStatus.Experimental
    public ParseResult<EXCEPTED> whenFailed(Consumer<FailedReason> var1);

    public static <PARSED> ParseCompletedResult<PARSED> success(PARSED parsed) {
        return new ParseCompletedResult<PARSED>(parsed, null, false, Collections.emptyList());
    }

    public static <T> ParseCompletedResult<T> successNull() {
        return (ParseCompletedResult)ParseCompletedResult.NULL_SUCCESS;
    }

    public static <EXPECTED> ParseCompletedResult<EXPECTED> failure(FailedReason failedReason) {
        return new ParseCompletedResult<Object>(null, failedReason, false, Collections.emptyList());
    }

    public static <EXPECTED> ParseCompletedResult<EXPECTED> failure(Object failedReason) {
        return new ParseCompletedResult<Object>(null, FailedReason.of(failedReason), false, Collections.emptyList());
    }

    @ApiStatus.Experimental
    public static <EXPECTED> ParseCompletedResult<EXPECTED> conditional(EXPECTED parsed, List<RequirementCondition> conditions) {
        return new ParseCompletedResult<EXPECTED>(parsed, null, false, Collections.unmodifiableList(conditions));
    }

    @ApiStatus.Experimental
    public static <EXPECTED> ParseCompletedResult<EXPECTED> conditional(EXPECTED parsed, RequirementCondition ... conditions) {
        return new ParseCompletedResult<EXPECTED>(parsed, null, false, Arrays.asList(conditions));
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static <EXPECTED> ParseAsyncResult<EXPECTED> completableFuture(CompletableFuture<? extends ParseResult<EXPECTED>> future) {
        return new ParseAsyncResult(future);
    }

    @ApiStatus.Experimental
    public static <T, EXPECTED> ParseAsyncResult<EXPECTED> completableFuture(CompletableFuture<T> future, Function<@UnknownNullability T, ? extends ParseResult<EXPECTED>> mapper) {
        return new ParseAsyncResult(future.thenApply(mapper));
    }

    @ApiStatus.Experimental
    public static <EXPECTED> ParseAsyncResult<EXPECTED> async(Supplier<? extends ParseResult<EXPECTED>> supplier) {
        return new ParseAsyncResult(CompletableFuture.supplyAsync(supplier));
    }

    @ApiStatus.Experimental
    public static <EXPECTED> ParseAsyncResult<EXPECTED> async(Supplier<? extends ParseResult<EXPECTED>> supplier, Executor executor) {
        return new ParseAsyncResult(CompletableFuture.supplyAsync(supplier, executor));
    }
}

