/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.lib.com.eternalcode.multification.notice;

import com.github.imdmk.automessage.lib.com.eternalcode.multification.adventure.AudienceConverter;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.executor.AsyncExecutor;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.locate.LocaleProvider;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.LanguageViewersIndex;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.Notice;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.NoticeBroadcast;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.NoticeKey;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.NoticePart;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.TranslatedNoticesIndex;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.provider.NoticeProvider;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.provider.OptionalNoticeProvider;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.provider.TextMessageProvider;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.resolver.NoticeContent;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.resolver.NoticeResolverRegistry;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.resolver.text.TextContent;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.platform.PlatformBroadcaster;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.shared.Formatter;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.shared.Replacer;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.translation.TranslationProvider;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.viewer.ViewerProvider;
import com.github.imdmk.automessage.lib.net.kyori.adventure.audience.Audience;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.CheckReturnValue;

public class NoticeBroadcastImpl<VIEWER, TRANSLATION, B extends NoticeBroadcast<VIEWER, TRANSLATION, B>>
implements NoticeBroadcast<VIEWER, TRANSLATION, B> {
    protected final AsyncExecutor asyncExecutor;
    protected final TranslationProvider<TRANSLATION> translationProvider;
    protected final ViewerProvider<VIEWER> viewerProvider;
    protected final PlatformBroadcaster platformBroadcaster;
    protected final LocaleProvider<VIEWER> localeProvider;
    protected final AudienceConverter<VIEWER> audienceConverter;
    protected final Replacer<VIEWER> globalReplacer;
    protected final NoticeResolverRegistry noticeRegistry;
    protected final List<VIEWER> viewers = new ArrayList<VIEWER>();
    protected final List<NoticeProvider<TRANSLATION>> notifications = new ArrayList<NoticeProvider<TRANSLATION>>();
    protected final Map<String, TextMessageProvider<TRANSLATION>> placeholders = new HashMap<String, TextMessageProvider<TRANSLATION>>();
    protected final List<Formatter> formatters = new ArrayList<Formatter>();

    public NoticeBroadcastImpl(AsyncExecutor asyncExecutor, TranslationProvider<TRANSLATION> translationProvider, ViewerProvider<VIEWER> viewerProvider, PlatformBroadcaster platformBroadcaster, LocaleProvider<VIEWER> localeProvider, AudienceConverter<VIEWER> audienceConverter, Replacer<VIEWER> replacer, NoticeResolverRegistry noticeRegistry) {
        this.asyncExecutor = asyncExecutor;
        this.translationProvider = translationProvider;
        this.viewerProvider = viewerProvider;
        this.platformBroadcaster = platformBroadcaster;
        this.localeProvider = localeProvider;
        this.audienceConverter = audienceConverter;
        this.globalReplacer = replacer;
        this.noticeRegistry = noticeRegistry;
    }

    @Override
    @CheckReturnValue
    public B player(UUID player) {
        this.viewers.add(this.viewerProvider.player(player));
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B players(Iterable<UUID> players) {
        HashSet<VIEWER> viewers = new HashSet<VIEWER>();
        for (UUID player : players) {
            viewers.add(this.viewerProvider.player(player));
        }
        this.viewers.addAll(viewers);
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B viewer(VIEWER viewer) {
        this.viewers.add(viewer);
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B console() {
        this.viewers.add(this.viewerProvider.console());
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B all() {
        this.viewers.addAll(this.viewerProvider.all());
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B onlinePlayers() {
        this.viewers.addAll(this.viewerProvider.onlinePlayers());
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B onlinePlayers(String permission) {
        this.viewers.addAll(this.viewerProvider.onlinePlayers(permission));
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B noticeChat(TextMessageProvider<TRANSLATION> extractor) {
        this.notifications.add(translation -> Notice.chat(extractor.extract(translation)));
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B noticeChat(Function<TRANSLATION, List<String>> function) {
        TextMessageProvider<Object> translatedMessageExtractor = translation -> {
            List apply = (List)function.apply(translation);
            return String.join((CharSequence)"\n", apply);
        };
        return this.noticeChat(translatedMessageExtractor);
    }

    @Override
    @CheckReturnValue
    public B notice(Notice notification) {
        this.notifications.add(translation -> notification);
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B noticeOptional(OptionalNoticeProvider<TRANSLATION> extractor) {
        this.notifications.add(translation -> {
            Optional<Notice> apply = extractor.extract(translation);
            if (apply.isPresent()) {
                return apply.get();
            }
            return Notice.empty();
        });
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B notice(NoticeProvider<TRANSLATION> extractor) {
        this.notifications.add(extractor);
        return this.getThis();
    }

    @Override
    public B notice(NoticeKey<TextContent> type, String ... text) {
        TextContent content = this.noticeRegistry.createTextNotice(type, List.of(text));
        this.notifications.add(translation -> Notice.of(type, content));
        return this.getThis();
    }

    @Override
    public B notice(NoticeKey<TextContent> type, Collection<String> text) {
        TextContent content = this.noticeRegistry.createTextNotice(type, new ArrayList<String>(text));
        this.notifications.add(translation -> Notice.of(type, content));
        return this.getThis();
    }

    @Override
    public B notice(NoticeKey<TextContent> type, TextMessageProvider<TRANSLATION> extractor) {
        this.notifications.add(translation -> {
            List<String> list = Collections.singletonList(extractor.extract(translation));
            Object content = this.noticeRegistry.createTextNotice(type, list);
            return Notice.of(type, content);
        });
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B placeholder(String from, String to) {
        this.placeholders.put(from, translation -> to);
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B placeholder(String from, Optional<String> to) {
        if (to.isPresent()) {
            this.placeholders.put(from, translation -> (String)to.get());
        }
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B placeholder(String from, Supplier<String> to) {
        this.placeholders.put(from, translation -> (String)to.get());
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B placeholder(String from, TextMessageProvider<TRANSLATION> extractor) {
        this.placeholders.put(from, extractor);
        return this.getThis();
    }

    @Override
    @CheckReturnValue
    public B formatter(Formatter ... formatters) {
        this.formatters.addAll(Arrays.asList(formatters));
        return this.getThis();
    }

    @Override
    public void sendAsync() {
        this.asyncExecutor.execute(() -> this.send());
    }

    @Override
    public void send() {
        LanguageViewersIndex<VIEWER> viewersIndex = LanguageViewersIndex.of(this.localeProvider, this.viewers);
        TranslatedNoticesIndex translatedNoticesIndex = this.prepareTranslatedNotices(viewersIndex.getLocales());
        this.sendTranslatedMessages(viewersIndex, translatedNoticesIndex);
    }

    private void sendTranslatedMessages(LanguageViewersIndex<VIEWER> viewersIndex, TranslatedNoticesIndex translatedNoticesIndex) {
        for (Locale language : viewersIndex.getLocales()) {
            List<Notice> notificationsForLang = translatedNoticesIndex.forLanguage(language);
            if (notificationsForLang == null) continue;
            TranslatedFormatter translatedFormatter = this.prepareFormatterForLanguage(language);
            for (Notice notice : notificationsForLang) {
                Set<VIEWER> languageViewers = viewersIndex.getViewers(language);
                for (Object viewer : languageViewers) {
                    Audience audience = this.audienceConverter.convert(viewer);
                    for (NoticePart<?> part : notice.parts()) {
                        part = this.applyText(part, message -> translatedFormatter.format((String)message, viewer));
                        this.platformBroadcaster.announce(audience, part);
                    }
                }
            }
        }
    }

    protected <T extends NoticeContent> NoticePart<T> applyText(NoticePart<T> part, UnaryOperator<String> function) {
        if (part.content() instanceof TextContent) {
            return this.noticeRegistry.applyText(part, function);
        }
        return part;
    }

    private TranslatedNoticesIndex prepareTranslatedNotices(Set<Locale> languages) {
        return TranslatedNoticesIndex.of(languages, language -> {
            TRANSLATION translation = this.translationProvider.provide((Locale)language);
            ArrayList<Notice> notificationsForLanguage = new ArrayList<Notice>();
            for (NoticeProvider<TRANSLATION> extractor : this.notifications) {
                notificationsForLanguage.add(extractor.extract(translation));
            }
            return notificationsForLanguage;
        });
    }

    protected TranslatedFormatter prepareFormatterForLanguage(Locale language) {
        Object translation = this.translationProvider.provide(language);
        Formatter translatedFormatter = new Formatter();
        for (Map.Entry entry : this.placeholders.entrySet()) {
            translatedFormatter.register(entry.getKey(), () -> ((TextMessageProvider)entry.getValue()).extract(translation));
        }
        return new TranslatedFormatter(translatedFormatter);
    }

    protected B getThis() {
        return (B)this;
    }

    protected class TranslatedFormatter {
        protected final Formatter translatedPlaceholders;

        protected TranslatedFormatter(Formatter translatedPlaceholders) {
            this.translatedPlaceholders = translatedPlaceholders;
        }

        public String format(String text, VIEWER viewer) {
            text = NoticeBroadcastImpl.this.globalReplacer.apply(viewer, text);
            text = this.translatedPlaceholders.format(text);
            for (Formatter formatter : NoticeBroadcastImpl.this.formatters) {
                text = formatter.format(text);
            }
            return text;
        }
    }
}

