/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.config;

import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.DumperOptions;
import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.nodes.Node;
import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.nodes.Tag;
import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.representer.Represent;
import com.github.imdmk.automessage.lib.org.yaml.snakeyaml.representer.Representer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class ConfigRepresenter
extends Representer {
    ConfigRepresenter(DumperOptions options) {
        super(options);
        this.representers.put(String.class, new RepresentString());
        this.representers.put(Boolean.class, new RepresentBoolean());
        this.representers.put(Integer.class, new RepresentInteger());
        this.representers.put(ArrayList.class, new RepresentList());
        this.representers.put(Map.class, new RepresentMap());
        this.representers.put(HashMap.class, new RepresentMap());
        this.representers.put(LinkedHashMap.class, new RepresentMap());
    }

    private class RepresentString
    implements Represent {
        private RepresentString() {
        }

        @Override
        public Node representData(Object data) {
            String string;
            if (data instanceof String && ((string = (String)data).isEmpty() || string.contains(" "))) {
                return ConfigRepresenter.this.representScalar(Tag.STR, string, DumperOptions.ScalarStyle.DOUBLE_QUOTED);
            }
            return ConfigRepresenter.this.representScalar(Tag.STR, data.toString(), DumperOptions.ScalarStyle.PLAIN);
        }
    }

    private class RepresentBoolean
    implements Represent {
        private RepresentBoolean() {
        }

        @Override
        public Node representData(Object data) {
            return ConfigRepresenter.this.representScalar(Tag.BOOL, data.toString(), DumperOptions.ScalarStyle.PLAIN);
        }
    }

    private class RepresentInteger
    implements Represent {
        private RepresentInteger() {
        }

        @Override
        public Node representData(Object data) {
            return ConfigRepresenter.this.representScalar(Tag.INT, data.toString(), DumperOptions.ScalarStyle.PLAIN);
        }
    }

    private class RepresentList
    implements Represent {
        private RepresentList() {
        }

        @Override
        public Node representData(Object data) {
            return ConfigRepresenter.this.representSequence(ConfigRepresenter.this.getTag(data.getClass(), Tag.SEQ), (Iterable)data, DumperOptions.FlowStyle.BLOCK);
        }
    }

    private class RepresentMap
    implements Represent {
        private RepresentMap() {
        }

        @Override
        public Node representData(Object data) {
            return ConfigRepresenter.this.representMapping(Tag.MAP, (Map)data, DumperOptions.FlowStyle.BLOCK);
        }
    }
}

