/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.config;

import com.github.imdmk.automessage.config.ConfigBinder;
import com.github.imdmk.automessage.config.ConfigFactory;
import com.github.imdmk.automessage.config.ConfigLifecycle;
import com.github.imdmk.automessage.config.ConfigSection;
import com.github.imdmk.automessage.platform.logger.PluginLogger;
import com.github.imdmk.automessage.shared.validate.Validator;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class ConfigManager {
    private final Set<ConfigSection> configs = ConcurrentHashMap.newKeySet();
    private final Map<Class<?>, ConfigSection> byType = new ConcurrentHashMap();
    private final File dataFolder;
    private final ConfigFactory factory;
    private final ConfigBinder binder;
    private final ConfigLifecycle lifecycle;

    public ConfigManager(@NotNull PluginLogger logger, @NotNull File dataFolder) {
        this.dataFolder = Validator.notNull(dataFolder, "dataFolder");
        this.factory = new ConfigFactory();
        this.binder = new ConfigBinder();
        this.lifecycle = new ConfigLifecycle(logger);
    }

    @NotNull
    public <T extends ConfigSection> T create(@NotNull Class<T> type) {
        T config = this.factory.instantiate(type);
        File file = new File(this.dataFolder, ((ConfigSection)config).getFileName());
        this.binder.bind((ConfigSection)config, file);
        this.lifecycle.initialize((ConfigSection)config);
        this.register(type, (ConfigSection)config);
        return config;
    }

    public void createAll(@NotNull List<Class<? extends ConfigSection>> types) {
        types.forEach(this::create);
    }

    public <T extends ConfigSection> T get(@NotNull Class<T> type) {
        return (T)this.byType.get(type);
    }

    @NotNull
    public <T extends ConfigSection> T require(@NotNull Class<T> type) {
        T config = this.get(type);
        if (config == null) {
            throw new IllegalStateException("Config not created: " + type.getName());
        }
        return config;
    }

    public void loadAll() {
        this.configs.forEach(this.lifecycle::load);
    }

    public void saveAll() {
        this.configs.forEach(this.lifecycle::save);
    }

    @NotNull
    public @Unmodifiable Set<ConfigSection> getConfigs() {
        return Collections.unmodifiableSet(this.configs);
    }

    public void clearAll() {
        this.configs.clear();
        this.byType.clear();
    }

    private void register(Class<?> type, ConfigSection config) {
        this.configs.add(config);
        this.byType.put(type, config);
    }
}

