/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.config;

import com.github.imdmk.automessage.config.ConfigAccessException;
import com.github.imdmk.automessage.config.ConfigSection;
import com.github.imdmk.automessage.lib.eu.okaeri.configs.exception.OkaeriException;
import com.github.imdmk.automessage.platform.logger.PluginLogger;
import com.github.imdmk.automessage.shared.validate.Validator;
import org.jetbrains.annotations.NotNull;

final class ConfigLifecycle {
    private final PluginLogger logger;

    ConfigLifecycle(@NotNull PluginLogger logger) {
        this.logger = Validator.notNull(logger, "logger");
    }

    void initialize(@NotNull ConfigSection config) {
        config.saveDefaults();
        this.load(config);
    }

    void load(@NotNull ConfigSection config) {
        try {
            config.load(true);
        }
        catch (OkaeriException e) {
            this.logger.error(e, "Failed to load config %s", config.getClass().getSimpleName());
            throw new ConfigAccessException(e);
        }
    }

    void save(@NotNull ConfigSection config) {
        try {
            config.save();
        }
        catch (Exception e) {
            this.logger.error(e, "Failed to save config %s", config.getClass().getSimpleName());
            throw new ConfigAccessException(e);
        }
    }
}

