/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage.command.reload;

import com.github.imdmk.automessage.config.ConfigManager;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.command.Command;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.context.Context;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.execute.Execute;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.annotations.permission.Permission;
import com.github.imdmk.automessage.platform.logger.PluginLogger;
import com.github.imdmk.automessage.platform.scheduler.TaskScheduler;
import com.github.imdmk.automessage.shared.message.MessageService;
import com.github.imdmk.automessage.shared.validate.Validator;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@Command(name="automessage reload")
@Permission(value={"command.automessage.reload"})
public final class ReloadCommand {
    private final PluginLogger logger;
    private final ConfigManager configManager;
    private final TaskScheduler taskScheduler;
    private final MessageService messageService;

    public ReloadCommand(@NotNull PluginLogger logger, @NotNull ConfigManager configManager, @NotNull TaskScheduler taskScheduler, @NotNull MessageService messageService) {
        this.logger = Validator.notNull(logger, "logger");
        this.configManager = Validator.notNull(configManager, "configManager");
        this.taskScheduler = Validator.notNull(taskScheduler, "taskScheduler");
        this.messageService = Validator.notNull(messageService, "messageService");
    }

    @Execute
    void reload(@Context CommandSender sender) {
        this.taskScheduler.runAsync(() -> {
            try {
                this.configManager.loadAll();
                this.messageService.send(sender, n -> n.reloadMessages.configReloadedSuccess());
            }
            catch (Exception e) {
                this.logger.error(e, "Failed to reload plugin config");
                this.messageService.send(sender, n -> n.reloadMessages.configReloadFailed());
            }
        });
    }
}

