/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.automessage;

import com.github.imdmk.automessage.PluginSettings;
import com.github.imdmk.automessage.command.dispatcher.DisableCommand;
import com.github.imdmk.automessage.command.dispatcher.EnableCommand;
import com.github.imdmk.automessage.command.reload.ReloadCommand;
import com.github.imdmk.automessage.config.ConfigManager;
import com.github.imdmk.automessage.lib.com.eternalcode.multification.notice.Notice;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.LiteCommands;
import com.github.imdmk.automessage.lib.dev.rollczi.litecommands.bukkit.LiteBukkitFactory;
import com.github.imdmk.automessage.lib.net.kyori.adventure.platform.AudienceProvider;
import com.github.imdmk.automessage.lib.net.kyori.adventure.platform.bukkit.BukkitAudiences;
import com.github.imdmk.automessage.lib.org.bstats.bukkit.Metrics;
import com.github.imdmk.automessage.platform.litecommands.handler.InvalidUsageHandlerImpl;
import com.github.imdmk.automessage.platform.litecommands.handler.MissingPermissionsHandlerImpl;
import com.github.imdmk.automessage.platform.litecommands.handler.NoticeResultHandlerImpl;
import com.github.imdmk.automessage.platform.logger.BukkitPluginLogger;
import com.github.imdmk.automessage.platform.logger.PluginLogger;
import com.github.imdmk.automessage.platform.scheduler.BukkitTaskScheduler;
import com.github.imdmk.automessage.platform.scheduler.TaskScheduler;
import com.github.imdmk.automessage.scheduled.ScheduledMessagesConfig;
import com.github.imdmk.automessage.scheduled.audience.filter.AudienceFilter;
import com.github.imdmk.automessage.scheduled.dispatcher.MessageDispatcher;
import com.github.imdmk.automessage.scheduled.dispatcher.MessageDispatcherConfig;
import com.github.imdmk.automessage.scheduled.dispatcher.MessageDispatcherTask;
import com.github.imdmk.automessage.scheduled.selector.MessageSelector;
import com.github.imdmk.automessage.scheduled.selector.MessageSelectorFactory;
import com.github.imdmk.automessage.shared.message.MessageConfig;
import com.github.imdmk.automessage.shared.message.MessageService;
import com.github.imdmk.automessage.shared.validate.Validator;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

final class AutoMessagePlugin {
    private static final String PLUGIN_PREFIX = "AutoMessage";
    private static final int PLUGIN_METRICS_ID = 19487;
    private final Plugin plugin;
    private final Server server;
    private final PluginLogger logger;
    private ConfigManager configManager;
    private BukkitAudiences bukkitAudiences;
    private MessageService messageService;
    private TaskScheduler taskScheduler;
    private LiteCommands<?> liteCommands;
    private Metrics metrics;

    public AutoMessagePlugin(@NotNull Plugin plugin, @NotNull Server server, @NotNull PluginLogger logger) {
        this.plugin = Validator.notNull(plugin, "plugin");
        this.server = Validator.notNull(server, "server");
        this.logger = Validator.notNull(logger, "logger");
    }

    AutoMessagePlugin(@NotNull Plugin plugin) {
        this(plugin, plugin.getServer(), new BukkitPluginLogger(plugin));
    }

    void enable(@NotNull PluginSettings settings) {
        Validator.notNull(settings, "settings");
        this.configManager = new ConfigManager(this.logger, this.plugin.getDataFolder());
        this.configManager.createAll(settings.configs());
        this.bukkitAudiences = BukkitAudiences.create(this.plugin);
        this.messageService = new MessageService(this.configManager.require(MessageConfig.class), this.bukkitAudiences);
        this.taskScheduler = new BukkitTaskScheduler(this.plugin, this.server.getScheduler());
        MessageDispatcherConfig messageDispatcherConfig = this.configManager.require(MessageDispatcherConfig.class);
        ScheduledMessagesConfig scheduledMessagesConfig = this.configManager.require(ScheduledMessagesConfig.class);
        AudienceFilter audienceFilter = AudienceFilter.createDefault();
        MessageSelector messageSelector = MessageSelectorFactory.create(messageDispatcherConfig.selector);
        MessageDispatcher messageDispatcher = new MessageDispatcher(this.messageService, messageSelector, audienceFilter, () -> scheduledMessagesConfig.messages);
        MessageDispatcherTask messageDispatcherTask = new MessageDispatcherTask(this.server, messageDispatcherConfig, messageDispatcher);
        this.taskScheduler.runTimerAsync(messageDispatcherTask);
        this.liteCommands = LiteBukkitFactory.builder(PLUGIN_PREFIX, this.plugin, this.server).invalidUsage(new InvalidUsageHandlerImpl(this.messageService)).missingPermission(new MissingPermissionsHandlerImpl(this.messageService)).result(Notice.class, new NoticeResultHandlerImpl(this.messageService)).commands(new DisableCommand(messageDispatcherConfig, this.messageService), new EnableCommand(messageDispatcherConfig, this.messageService), new ReloadCommand(this.logger, this.configManager, this.taskScheduler, this.messageService)).build();
        this.metrics = new Metrics(this.plugin, 19487);
        this.logger.info("%s plugin enabled.", PLUGIN_PREFIX);
    }

    void disable() {
        Validator.ifNotNull(this.bukkitAudiences, AudienceProvider::close);
        Validator.ifNotNull(this.taskScheduler, TaskScheduler::shutdown);
        Validator.ifNotNull(this.liteCommands, LiteCommands::unregister);
        Validator.ifNotNull(this.metrics, Metrics::shutdown);
        this.logger.info("%s plugin disabled successfully.", PLUGIN_PREFIX);
    }
}

